/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.webdriver;

import com.codeborne.selenide.Browser;
import com.codeborne.selenide.Config;
import com.codeborne.selenide.WebDriverProvider;
import com.codeborne.selenide.webdriver.AbstractDriverFactory;
import com.codeborne.selenide.webdriver.DriverFactory;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.jspecify.annotations.Nullable;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.WebDriver;

public class DefaultDriverFactory
extends AbstractDriverFactory {
    @Override
    public WebDriver create(Config config, Browser browser, @Nullable Proxy proxy, @Nullable File browserDownloadsFolder) {
        return this.createInstanceOf(config.browser(), config, browser, proxy, browserDownloadsFolder);
    }

    private WebDriver createInstanceOf(String className, Config config, Browser browser, @Nullable Proxy proxy, @Nullable File browserDownloadsFolder) {
        Class<?> clazz = this.classOf(config.browser());
        if (WebDriverProvider.class.isAssignableFrom(clazz)) {
            MutableCapabilities capabilities = this.createCapabilities(config, browser, proxy, browserDownloadsFolder);
            return this.createInstanceOf(WebDriverProvider.class, clazz).createDriver((Capabilities)capabilities);
        }
        if (DriverFactory.class.isAssignableFrom(clazz)) {
            DriverFactory factory = this.createInstanceOf(DriverFactory.class, clazz);
            return factory.create(config, browser, proxy, browserDownloadsFolder);
        }
        MutableCapabilities capabilities = this.createCapabilities(config, browser, proxy, browserDownloadsFolder);
        return this.createWebDriver(className, (Capabilities)capabilities);
    }

    @Override
    public MutableCapabilities createCapabilities(Config config, Browser browser, @Nullable Proxy proxy, @Nullable File browserDownloadsFolder) {
        Class<?> clazz = this.classOf(config.browser());
        if (DriverFactory.class.isAssignableFrom(clazz)) {
            DriverFactory factory = this.createInstanceOf(DriverFactory.class, clazz);
            return factory.createCapabilities(config, browser, proxy, browserDownloadsFolder);
        }
        return this.createCommonCapabilities(config, browser, proxy);
    }

    private Class<?> classOf(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Class not found: " + className, e);
        }
    }

    private WebDriver createWebDriver(String className, Capabilities capabilities) {
        try {
            Constructor<?> constructor = Class.forName(className).getConstructor(Capabilities.class);
            return (WebDriver)constructor.newInstance(capabilities);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to create WebDriver of type " + className, e);
        }
    }

    private <T> T createInstanceOf(Class<T> resultClass, Class<?> clazz) {
        try {
            Constructor<?> constructor = clazz.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            return (T)constructor.newInstance(new Object[0]);
        }
        catch (InvocationTargetException e) {
            throw this.runtime(e.getTargetException());
        }
        catch (Exception invalidClassName) {
            throw new IllegalArgumentException(invalidClassName);
        }
    }

    private RuntimeException runtime(Throwable exception) {
        return exception instanceof RuntimeException ? (RuntimeException)exception : new RuntimeException(exception);
    }
}

