/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.webdriver;

import com.codeborne.selenide.Browser;
import com.codeborne.selenide.Config;
import com.codeborne.selenide.webdriver.AbstractChromiumDriverFactory;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jspecify.annotations.Nullable;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeDriverService;
import org.openqa.selenium.chrome.ChromeOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChromeDriverFactory
extends AbstractChromiumDriverFactory {
    private static final Logger log = LoggerFactory.getLogger(ChromeDriverFactory.class);

    @Override
    public WebDriver create(Config config, Browser browser, @Nullable Proxy proxy, @Nullable File browserDownloadsFolder) {
        ChromeOptions chromeOptions = this.createCapabilities(config, browser, proxy, browserDownloadsFolder);
        log.debug("Chrome options: {}", (Object)chromeOptions);
        return new ChromeDriver(this.buildService(config), chromeOptions);
    }

    protected ChromeDriverService buildService(Config config) {
        return (ChromeDriverService)this.withLog(config, new ChromeDriverService.Builder());
    }

    public ChromeOptions createCapabilities(Config config, Browser browser, @Nullable Proxy proxy, @Nullable File browserDownloadsFolder) {
        ChromeOptions commonCapabilities = this.createCommonCapabilities(new ChromeOptions(), config, browser, proxy);
        ChromeOptions options = new ChromeOptions();
        if (config.headless()) {
            this.addHeadless(options);
        }
        if (StringUtils.isNotEmpty((CharSequence)config.browserBinary())) {
            log.info("Using browser binary: {}", (Object)config.browserBinary());
            options.setBinary(config.browserBinary());
        }
        options.addArguments(this.createChromeArguments(config, browser));
        options.setExperimentalOption("excludeSwitches", (Object)this.excludeSwitches((Capabilities)commonCapabilities));
        options.setExperimentalOption("prefs", this.prefs(browserDownloadsFolder, System.getProperty("chromeoptions.prefs", "")));
        this.setMobileEmulation(options);
        return this.merge(options, (MutableCapabilities)commonCapabilities);
    }

    protected void addHeadless(ChromeOptions options) {
        options.addArguments(new String[]{"--headless=new"});
    }

    protected List<String> createChromeArguments(Config config, Browser browser) {
        return this.createChromiumArguments(config, System.getProperty("chromeoptions.args"));
    }

    protected String[] excludeSwitches(Capabilities capabilities) {
        String[] stringArray;
        if (this.hasExtensions(capabilities)) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "enable-automation";
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = "enable-automation";
            stringArray = stringArray3;
            stringArray3[1] = "load-extension";
        }
        return stringArray;
    }

    private boolean hasExtensions(Capabilities capabilities) {
        Map chromeOptions = (Map)capabilities.getCapability("goog:chromeOptions");
        if (chromeOptions == null) {
            return false;
        }
        List extensions = (List)chromeOptions.get("extensions");
        return extensions != null && !extensions.isEmpty();
    }

    private void setMobileEmulation(ChromeOptions chromeOptions) {
        Map<String, Object> mobileEmulation = this.mobileEmulation();
        if (!mobileEmulation.isEmpty()) {
            chromeOptions.setExperimentalOption("mobileEmulation", mobileEmulation);
        }
    }

    protected Map<String, Object> mobileEmulation() {
        String mobileEmulation = System.getProperty("chromeoptions.mobileEmulation", "");
        return this.parsePreferencesFromString(mobileEmulation);
    }
}

