/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.logevents;

import com.codeborne.selenide.logevents.LogEvent;
import java.util.concurrent.TimeUnit;
import org.jspecify.annotations.Nullable;

public class SelenideLog
implements LogEvent {
    private final long startNs;
    private long endNs;
    private final String subject;
    private final String element;
    private LogEvent.EventStatus status = LogEvent.EventStatus.IN_PROGRESS;
    private @Nullable Throwable error;

    public SelenideLog(String element, String subject) {
        this.element = element;
        this.subject = subject;
        this.startNs = System.nanoTime();
    }

    @Override
    public String getSubject() {
        return this.subject;
    }

    @Override
    public LogEvent.EventStatus getStatus() {
        return this.status;
    }

    protected final void setStatus(LogEvent.EventStatus status) {
        this.status = status;
        this.endNs = System.nanoTime();
    }

    @Override
    public String getElement() {
        return this.element;
    }

    @Override
    public long getDuration() {
        return TimeUnit.NANOSECONDS.toMillis(this.getEndTime() - this.getStartTime());
    }

    @Override
    public long getStartTime() {
        return this.startNs;
    }

    @Override
    public long getEndTime() {
        return this.endNs;
    }

    @Override
    public @Nullable Throwable getError() {
        return this.error;
    }

    public final void setError(Throwable error) {
        this.error = error;
    }

    public String toString() {
        return String.format("$(\"%s\") %s", this.element, this.subject);
    }
}

