/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.codeborne.selenide.Config;
import com.codeborne.selenide.DownloadsFolder;
import com.codeborne.selenide.drivercommands.CloseDriverCommand;
import com.codeborne.selenide.impl.Disposable;
import com.codeborne.selenide.proxy.SelenideProxyServer;
import java.util.Objects;
import org.jspecify.annotations.Nullable;
import org.openqa.selenium.WebDriver;

public record WebDriverInstance(long threadId, Config config, WebDriver webDriver, @Nullable SelenideProxyServer proxy, @Nullable DownloadsFolder downloadsFolder) implements Disposable
{
    private final @Nullable SelenideProxyServer proxy;
    private static final String NOTICE = "Be sure to enable proxy BEFORE you open the browser.";
    private static final CloseDriverCommand closeDriverCommand = new CloseDriverCommand();

    public WebDriverInstance(Config config, WebDriver webDriver, @Nullable SelenideProxyServer proxy, @Nullable DownloadsFolder downloadsFolder) {
        this(Thread.currentThread().getId(), config, webDriver, proxy, downloadsFolder);
    }

    public WebDriverInstance(long threadId, Config config, WebDriver webDriver, @Nullable SelenideProxyServer proxy, @Nullable DownloadsFolder downloadsFolder) {
        Objects.requireNonNull(config, "config must not be null");
        Objects.requireNonNull(webDriver, "webDriver must not be null");
    }

    public SelenideProxyServer proxy() {
        if (!this.config.proxyEnabled()) {
            throw new IllegalStateException("Proxy server is not enabled. You need to set proxyEnabled=true before opening a browser.");
        }
        if (this.proxy == null) {
            throw new IllegalStateException("config.proxyEnabled == true but proxy server is not created. Be sure to enable proxy BEFORE you open the browser.");
        }
        if (!this.proxy.isStarted()) {
            throw new IllegalStateException("config.proxyEnabled == true but proxy server is not started. Be sure to enable proxy BEFORE you open the browser.");
        }
        return this.proxy;
    }

    @Override
    public void dispose() {
        closeDriverCommand.close(this);
    }
}

