/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import java.io.File;
import org.jspecify.annotations.Nullable;

public class Screenshot {
    private final @Nullable File imageFile;
    private final @Nullable String image;
    private final @Nullable String source;

    public Screenshot(@Nullable File imageFile, @Nullable String imageUrl, @Nullable String source) {
        this.imageFile = imageFile;
        this.image = imageUrl;
        this.source = source;
    }

    @Nullable File getImageFile() {
        return this.imageFile;
    }

    public @Nullable String getImage() {
        return this.image;
    }

    public @Nullable String getSource() {
        return this.source;
    }

    public static Screenshot none() {
        return new Screenshot(null, null, null);
    }

    public boolean isPresent() {
        return this.image != null || this.source != null;
    }

    public String summary() {
        if (this.image != null && this.source != null) {
            return String.format("Screenshot: %s%nPage source: %s", this.image, this.source);
        }
        if (this.source != null) {
            return String.format("Page source: %s", this.source);
        }
        if (this.image != null) {
            return String.format("Screenshot: %s", this.image);
        }
        return "";
    }

    public String toString() {
        return this.summary();
    }
}

