/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FileHelper {
    private static final Logger log = LoggerFactory.getLogger(FileHelper.class);

    private FileHelper() {
    }

    public static void copyFile(InputStream in, File targetFile) throws IOException {
        FileHelper.ensureParentFolderExists(targetFile);
        try (FileOutputStream out = new FileOutputStream(targetFile);){
            int len;
            byte[] buffer = new byte[1024];
            while ((len = in.read(buffer)) != -1) {
                out.write(buffer, 0, len);
            }
        }
    }

    public static void ensureParentFolderExists(File targetFile) {
        FileHelper.ensureFolderExists(targetFile.getParentFile());
    }

    @CanIgnoreReturnValue
    public static File ensureFolderExists(File folder) {
        if (!folder.exists() || !folder.getAbsoluteFile().exists()) {
            log.debug("Creating folder: {}", (Object)folder.getAbsolutePath());
            try {
                Files.createDirectories(folder.toPath(), new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Failed to create folder '" + folder.getAbsolutePath() + "'", e);
            }
        }
        return folder;
    }

    public static void moveFile(File srcFile, File destFile) {
        try {
            FileUtils.moveFile((File)srcFile, (File)destFile);
        }
        catch (IOException e) {
            File dir = srcFile.getParentFile();
            throw new IllegalStateException("Failed to move file " + srcFile.getAbsolutePath() + " to " + destFile.getAbsolutePath() + " (files in " + String.valueOf(dir) + ": " + String.valueOf(FileHelper.list(dir)) + ")", e);
        }
    }

    private static List<String> list(File dir) {
        try {
            String[] files = dir.list();
            return files == null ? Collections.emptyList() : Arrays.asList(files);
        }
        catch (RuntimeException e) {
            return Collections.singletonList("Failed to list files in directory " + String.valueOf(dir) + ": " + String.valueOf(e));
        }
    }

    public static void deleteFolderIfEmpty(File folder) {
        File[] files;
        if (folder.isDirectory() && ((files = folder.listFiles()) == null || files.length == 0)) {
            if (folder.delete()) {
                log.debug("Deleted empty folder: {}", (Object)folder.getAbsolutePath());
            } else {
                log.error("Failed to delete empty folder: {}", (Object)folder.getAbsolutePath());
            }
        }
    }

    public static void deleteFolder(File folder) {
        try {
            FileUtils.deleteDirectory((File)folder);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to delete folder: " + folder.getAbsolutePath(), e);
        }
    }
}

