/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.codeborne.selenide.Browser;
import com.codeborne.selenide.DownloadsFolder;
import com.codeborne.selenide.Driver;
import com.codeborne.selenide.Stopwatch;
import com.codeborne.selenide.ex.FileNotDownloadedError;
import com.codeborne.selenide.files.DownloadAction;
import com.codeborne.selenide.files.DownloadedFile;
import com.codeborne.selenide.files.FileFilter;
import com.codeborne.selenide.impl.Downloader;
import com.codeborne.selenide.impl.FileHelper;
import com.codeborne.selenide.impl.WebElementSource;
import java.io.File;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.openqa.selenium.HasCapabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.devtools.DevTools;
import org.openqa.selenium.devtools.HasDevTools;
import org.openqa.selenium.devtools.v140.browser.Browser;
import org.openqa.selenium.devtools.v140.browser.model.DownloadProgress;
import org.openqa.selenium.devtools.v140.browser.model.DownloadWillBegin;
import org.openqa.selenium.devtools.v140.page.Page;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DownloadFileWithCdp {
    private static final Logger log = LoggerFactory.getLogger(DownloadFileWithCdp.class);
    private static final AtomicLong SEQUENCE = new AtomicLong();
    protected final Downloader downloader;

    DownloadFileWithCdp(Downloader downloader) {
        this.downloader = downloader;
    }

    public DownloadFileWithCdp() {
        this(new Downloader());
    }

    protected @Nullable DownloadsFolder getDownloadsFolder(Driver driver) {
        return driver.browserDownloadsFolder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File download(WebElementSource anyClickableElement, WebElement clickable, long timeout, long incrementTimeout, FileFilter fileFilter, DownloadAction action) {
        Driver driver = anyClickableElement.driver();
        DevTools devTools = this.initDevTools(driver);
        DownloadsFolder downloadsFolder = Objects.requireNonNull(this.getDownloadsFolder(driver), "Webdriver downloads folder is not configured");
        CdpDownloads downloads = new CdpDownloads(downloadsFolder, new ConcurrentHashMap<String, CdpDownload>(1));
        this.prepareDownloadWithCdp(driver, devTools, downloads, timeout);
        action.perform(anyClickableElement.driver(), clickable);
        try {
            File file = this.waitUntilDownloadsCompleted(anyClickableElement.driver(), fileFilter, timeout, incrementTimeout, downloads);
            if (!fileFilter.match(new DownloadedFile(file, Collections.emptyMap()))) {
                String message = String.format("Failed to download file%s in %d ms.%s;%n actually downloaded: %s", fileFilter.description(), timeout, fileFilter.description(), file.getAbsolutePath());
                throw new FileNotDownloadedError(message, timeout);
            }
            File file2 = this.archiveFile(anyClickableElement.driver(), file);
            return file2;
        }
        finally {
            devTools.clearListeners();
        }
    }

    protected File archiveFile(Driver driver, File downloadedFile) {
        File uniqueFolder = this.downloader.prepareTargetFolder(driver.config());
        File archivedFile = new File(uniqueFolder, downloadedFile.getName());
        FileHelper.moveFile(downloadedFile, archivedFile);
        log.debug("Moved the downloaded file {} to {}", (Object)downloadedFile, (Object)archivedFile);
        return archivedFile;
    }

    private File waitUntilDownloadsCompleted(Driver driver, FileFilter fileFilter, long timeout, long incrementTimeout, CdpDownloads downloads) {
        long pollingInterval = Math.max(driver.config().pollingInterval(), 100L);
        long downloadStartedAt = System.currentTimeMillis();
        Stopwatch stopwatch = new Stopwatch(timeout);
        do {
            Optional<CdpDownload> downloadedFile;
            if ((downloadedFile = downloads.find(fileFilter)).isPresent()) {
                log.debug("File {} download is complete after {} ms.", (Object)downloadedFile.get().fileName, (Object)stopwatch.getElapsedTimeMs());
                return downloadedFile.get().file();
            }
            this.failFastIfNoChanges(downloads, fileFilter, downloadStartedAt, timeout, incrementTimeout);
            stopwatch.sleep(pollingInterval);
        } while (!stopwatch.isTimeoutReached());
        String message = "Failed to download file%s in %d ms., found files: %s".formatted(fileFilter.description(), timeout, downloads.folder().files());
        throw new FileNotDownloadedError(message, timeout);
    }

    private DevTools initDevTools(Driver driver) {
        WebDriver webDriver = driver.getWebDriver();
        if (!(webDriver instanceof HasDevTools)) {
            throw new IllegalArgumentException("The browser you selected \"%s\" doesn't support Chrome Devtools protocol".formatted(driver.browser().name));
        }
        HasDevTools cdpBrowser = (HasDevTools)webDriver;
        if (!this.isChromium(webDriver)) {
            throw new IllegalArgumentException("The browser you selected \"%s\" is not Chromium browser".formatted(driver.browser().name));
        }
        DevTools devTools = cdpBrowser.getDevTools();
        devTools.createSessionIfThereIsNotOne();
        devTools.send(Page.enable(Optional.empty()));
        return devTools;
    }

    private boolean isChromium(WebDriver webDriver) {
        HasCapabilities hasCapabilities;
        return webDriver instanceof HasCapabilities && new Browser((hasCapabilities = (HasCapabilities)webDriver).getCapabilities().getBrowserName(), false).isChromium();
    }

    private void prepareDownloadWithCdp(Driver driver, DevTools devTools, CdpDownloads downloads, long timeout) {
        devTools.send(org.openqa.selenium.devtools.v140.browser.Browser.setDownloadBehavior((Browser.SetDownloadBehaviorBehavior)Browser.SetDownloadBehaviorBehavior.DEFAULT, Optional.empty(), Optional.empty(), Optional.of(true)));
        log.debug("clear devtools listeners");
        devTools.clearListeners();
        log.debug("add devtools listener for 'downloadWillBegin'");
        devTools.addListener(org.openqa.selenium.devtools.v140.browser.Browser.downloadWillBegin(), (Consumer)new DownloadWillBeginListener(DownloadFileWithCdp.id(), downloads));
        log.debug("add devtools listener for 'downloadProgress'");
        devTools.addListener(org.openqa.selenium.devtools.v140.browser.Browser.downloadProgress(), (Consumer)new DownloadProgressListener(DownloadFileWithCdp.id(), driver, downloads, timeout));
    }

    private static long id() {
        return SEQUENCE.incrementAndGet();
    }

    private void failFastIfNoChanges(CdpDownloads downloads, FileFilter filter, long downloadStartedAt, long timeout, long incrementTimeout) {
        long lastModifiedAt;
        long now = System.currentTimeMillis();
        long filesHasNotBeenUpdatedForMs = now - (lastModifiedAt = downloads.lastModificationTime().orElse(downloadStartedAt).longValue());
        if (filesHasNotBeenUpdatedForMs > incrementTimeout) {
            String message = String.format("Failed to download file%s in %d ms: files in %s haven't been modified for %s ms. (lastUpdate: %s, now: %s, incrementTimeout: %s)", filter.description(), timeout, downloads.folder, filesHasNotBeenUpdatedForMs, lastModifiedAt, now, incrementTimeout);
            throw new FileNotDownloadedError(message, timeout);
        }
    }

    private record CdpDownloads(DownloadsFolder folder, ConcurrentMap<String, CdpDownload> downloads) {
        private Optional<CdpDownload> find(FileFilter fileFilter) {
            return this.downloads.values().stream().filter(download -> download.completed).filter(download -> fileFilter.match(download.file())).findAny();
        }

        private Optional<Long> lastModificationTime() {
            return this.downloads.values().stream().map(download -> download.lastModifiedAt).max(Long::compare);
        }

        private void setName(String guid, String fileName) {
            this.download((String)guid).fileName = fileName;
        }

        public void inProgress(DownloadProgress e) {
            this.download((String)e.getGuid()).lastModifiedAt = System.currentTimeMillis();
            if (e.getReceivedBytes().longValue() >= e.getTotalBytes().longValue() && this.download(e.getGuid()).file().exists()) {
                this.finish(e.getGuid());
            }
        }

        public void finish(String guid) {
            this.download((String)guid).completed = true;
        }

        private synchronized CdpDownload download(String guid) {
            return this.downloads.computeIfAbsent(guid, __ -> new CdpDownload(this.folder));
        }
    }

    private static class CdpDownload {
        private final DownloadsFolder folder;
        private @Nullable String fileName;
        private long lastModifiedAt = System.currentTimeMillis();
        private boolean completed;

        private CdpDownload(DownloadsFolder folder) {
            this.folder = folder;
        }

        private File file() {
            return new File(this.folder.getPath(), Objects.requireNonNull(this.fileName));
        }
    }

    private record DownloadWillBeginListener(long id, CdpDownloads downloads) implements Consumer<DownloadWillBegin>
    {
        @Override
        public void accept(DownloadWillBegin e) {
            log.debug("[{}] Download will begin with suggested file name \"{}\" (url: \"{}\", frameId: {}, guid: {})", new Object[]{this.id, e.getSuggestedFilename(), e.getUrl(), e.getFrameId(), e.getGuid()});
            this.downloads.setName(e.getGuid(), e.getSuggestedFilename());
        }

        @Override
        public String toString() {
            return this.getClass().getSimpleName() + "#" + this.id;
        }
    }

    private record DownloadProgressListener(long id, Driver driver, CdpDownloads downloads, long timeout) implements Consumer<DownloadProgress>
    {
        @Override
        public void accept(DownloadProgress e) {
            log.debug("[{}] Download is {} (received bytes: {}, total bytes: {}, guid: {})", new Object[]{this.id, e.getState(), e.getReceivedBytes(), e.getTotalBytes(), e.getGuid()});
            switch (e.getState()) {
                case CANCELED: {
                    String message = "File download is %s (received bytes: %s, total bytes: %s, guid: %s)".formatted(e.getState(), e.getReceivedBytes(), e.getTotalBytes(), e.getGuid());
                    throw new FileNotDownloadedError(message, this.timeout);
                }
                case COMPLETED: {
                    this.downloads.finish(e.getGuid());
                    break;
                }
                case INPROGRESS: {
                    this.downloads.inProgress(e);
                }
            }
        }

        @Override
        public String toString() {
            return this.getClass().getSimpleName() + "#" + this.id;
        }
    }
}

