/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.codeborne.selenide.Condition;
import com.codeborne.selenide.Driver;
import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.WebElementCondition;
import com.codeborne.selenide.ex.ElementNotFound;
import com.codeborne.selenide.impl.CollectionSource;
import com.codeborne.selenide.impl.SelenideElementProxy;
import com.codeborne.selenide.impl.WebElementSource;
import java.lang.reflect.Proxy;
import org.jspecify.annotations.Nullable;
import org.openqa.selenium.WebElement;

public class CollectionElement
extends WebElementSource {
    private final CollectionSource collection;
    private final int index;

    public static SelenideElement wrap(CollectionSource collection, int index) {
        return CollectionElement.wrap(SelenideElement.class, collection, index);
    }

    public static <T extends SelenideElement> T wrap(Class<T> clazz, CollectionSource collection, int index) {
        return (T)((SelenideElement)Proxy.newProxyInstance(collection.getClass().getClassLoader(), new Class[]{clazz}, new SelenideElementProxy(new CollectionElement(collection, index))));
    }

    CollectionElement(CollectionSource collection, int index) {
        this.collection = collection;
        this.index = index;
    }

    @Override
    public Driver driver() {
        return this.collection.driver();
    }

    @Override
    public WebElement getWebElement() {
        return this.collection.getElement(this.index);
    }

    @Override
    public String getSearchCriteria() {
        return this.collection.getSearchCriteria() + "[" + this.index + "]";
    }

    @Override
    public String description() {
        return this.getAlias().getOrElse(() -> this.collection.shortDescription() + "[" + this.index + "]");
    }

    @Override
    public ElementNotFound createElementNotFoundError(WebElementCondition condition, @Nullable Throwable cause) {
        if (this.collection.getElements().isEmpty()) {
            return new ElementNotFound(this.getAlias(), this.getSearchCriteria(), Condition.visible, cause);
        }
        return super.createElementNotFoundError(condition, cause);
    }
}

