/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.files;

import com.codeborne.selenide.files.FileFilter;
import java.io.File;
import java.util.regex.Pattern;

class FilenameRegexFilter
implements FileFilter {
    private final Pattern fileNameRegex;

    FilenameRegexFilter(String fileNameRegex) {
        this.fileNameRegex = Pattern.compile(fileNameRegex);
    }

    @Override
    public boolean match(File file) {
        return this.fileNameRegex.matcher(file.getName()).matches();
    }

    @Override
    public String description() {
        return " with name matching \"" + String.valueOf(this.fileNameRegex) + "\"";
    }

    public String toString() {
        return this.description().trim();
    }
}

