/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.drivercommands;

import com.codeborne.selenide.impl.Disposable;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Predicate;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DisposablesRegistry<T extends Disposable> {
    private static final Logger log = LoggerFactory.getLogger(DisposablesRegistry.class);
    private @Nullable SelenideCleanupShutdownHook shutdownHook;
    private final List<T> disposables = new CopyOnWriteArrayList<T>();

    DisposablesRegistry() {
    }

    public synchronized void register(T disposable) {
        this.disposables.add(disposable);
        log.debug("Register {} in {} [size={}]", new Object[]{disposable, Thread.currentThread().getId(), this.disposables.size()});
        if (this.shutdownHook == null) {
            log.debug("Add shutdown hook in {} [size={}]", (Object)Thread.currentThread().getId(), (Object)this.disposables.size());
            this.shutdownHook = new SelenideCleanupShutdownHook();
            Runtime.getRuntime().addShutdownHook(this.shutdownHook);
        }
    }

    public synchronized void unregister(T webdriver) {
        this.disposables.remove(webdriver);
        log.debug("Unregister {} in {} [size={}]", new Object[]{webdriver, Thread.currentThread().getId(), this.disposables.size()});
    }

    synchronized void cancel() {
        if (this.isShutdownHookRegistered()) {
            log.debug("Remove shutdown hook in {}", (Object)Thread.currentThread().getId());
            Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
            this.shutdownHook = null;
        }
    }

    int size() {
        return this.disposables.size();
    }

    synchronized boolean isShutdownHookRegistered() {
        return this.shutdownHook != null;
    }

    void disposeAllItems() {
        this.disposables.forEach(Disposable::dispose);
    }

    public Optional<T> find(Predicate<T> filter) {
        return this.disposables.stream().filter(filter).findFirst();
    }

    private class SelenideCleanupShutdownHook
    extends Thread {
        private SelenideCleanupShutdownHook() {
        }

        @Override
        public void run() {
            log.debug("Run cleanup: size={}", (Object)DisposablesRegistry.this.disposables.size());
            DisposablesRegistry.this.disposeAllItems();
            log.debug("Finished cleanup");
        }
    }
}

