/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.conditions;

import com.codeborne.selenide.CheckResult;
import com.codeborne.selenide.Driver;
import com.codeborne.selenide.WebElementCondition;
import com.codeborne.selenide.conditions.Not;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.openqa.selenium.WebElement;

public class Or
extends WebElementCondition {
    private final List<? extends WebElementCondition> conditions;

    public Or(String name, List<? extends WebElementCondition> conditions) {
        super(name, Or.checkedConditionsListCtorArg(conditions).stream().anyMatch(WebElementCondition::missingElementSatisfiesCondition));
        this.conditions = conditions;
    }

    private static List<? extends WebElementCondition> checkedConditionsListCtorArg(List<? extends WebElementCondition> conditions) {
        if (conditions.isEmpty()) {
            throw new IllegalArgumentException("conditions list is empty");
        }
        return conditions;
    }

    @Override
    public WebElementCondition negate() {
        return new Not(this, this.conditions.stream().map(WebElementCondition::negate).anyMatch(WebElementCondition::missingElementSatisfiesCondition));
    }

    @Override
    public CheckResult check(Driver driver, WebElement element) {
        ArrayList<CheckResult> results = new ArrayList<CheckResult>();
        for (WebElementCondition webElementCondition : this.conditions) {
            CheckResult check2 = webElementCondition.check(driver, element);
            if (check2.verdict() == CheckResult.Verdict.ACCEPT) {
                return check2;
            }
            results.add(check2);
        }
        String actualValues = results.stream().map(check -> String.valueOf(check.actualValue())).collect(Collectors.joining(", "));
        return new CheckResult(CheckResult.Verdict.REJECT, (Object)actualValues);
    }

    @Override
    public String toString() {
        return this.getName() + ": " + this.conditions.stream().map(WebElementCondition::toString).collect(Collectors.joining(" or "));
    }
}

