/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.conditions;

import com.codeborne.selenide.CheckResult;
import com.codeborne.selenide.Driver;
import com.codeborne.selenide.WebElementCondition;
import java.util.Objects;
import org.jspecify.annotations.Nullable;
import org.openqa.selenium.WebElement;

public class DomAttributeValue
extends WebElementCondition {
    private final String domAttributeName;
    private final @Nullable String expectedDomAttributeValue;

    public DomAttributeValue(String domAttributeName, @Nullable String expectedDomAttributeValue) {
        super(String.format("dom attribute %s=\"%s\"", domAttributeName, expectedDomAttributeValue));
        this.domAttributeName = domAttributeName;
        this.expectedDomAttributeValue = expectedDomAttributeValue;
    }

    @Override
    public CheckResult check(Driver driver, WebElement element) {
        String attributeValue = element.getDomAttribute(this.domAttributeName);
        return new CheckResult(Objects.equals(this.expectedDomAttributeValue, attributeValue), (Object)String.format("%s=\"%s\"", this.domAttributeName, attributeValue));
    }
}

