/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.commands;

import com.codeborne.selenide.ClickOptions;
import com.codeborne.selenide.Command;
import com.codeborne.selenide.Condition;
import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.commands.Click;
import com.codeborne.selenide.commands.Util;
import com.codeborne.selenide.ex.ElementNotFound;
import com.codeborne.selenide.ex.InvalidStateError;
import com.codeborne.selenide.impl.WebElementSource;
import com.codeborne.selenide.impl.WebElementWrapper;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.openqa.selenium.WebElement;

public class SelectRadio
implements Command<SelenideElement> {
    private final Click click;

    public SelectRadio() {
        this(new Click());
    }

    SelectRadio(Click click) {
        this.click = click;
    }

    @Override
    public SelenideElement execute(SelenideElement proxy, WebElementSource locator, Object @Nullable [] args) {
        String value = (String)Util.firstOf(args);
        List<WebElement> matchingRadioButtons = locator.findAll();
        for (WebElement radio : matchingRadioButtons) {
            if (!value.equals(radio.getAttribute("value"))) continue;
            if (radio.getAttribute("readonly") != null) {
                throw new InvalidStateError(locator.description(), "Cannot select readonly radio button");
            }
            this.click.click(locator.driver(), radio, ClickOptions.usingDefaultMethod());
            return WebElementWrapper.wrap(locator.driver(), radio, locator.getSearchCriteria());
        }
        throw new ElementNotFound(locator.getAlias(), locator.getSearchCriteria(), Condition.value(value));
    }
}

