/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.commands;

import com.codeborne.selenide.Driver;
import com.codeborne.selenide.FluentCommand;
import com.codeborne.selenide.impl.WebElementSource;
import org.jspecify.annotations.Nullable;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.WebElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Clear
extends FluentCommand {
    private static final Logger log = LoggerFactory.getLogger(Clear.class);

    @Override
    protected void execute(WebElementSource locator, Object @Nullable [] args) {
        WebElement input = locator.findAndAssertElementIsEditable();
        this.clearAndTrigger(locator.driver(), input);
    }

    protected void clearAndTrigger(Driver driver, WebElement input) {
        this.clear(driver, input);
        this.blurSafely(driver, input);
    }

    protected void blurSafely(Driver driver, WebElement input) {
        try {
            driver.executeJavaScript("arguments[0].blur()", input);
        }
        catch (StaleElementReferenceException elementHasDisappeared) {
            log.debug("The input has disappeared after clearing: {}", (Object)elementHasDisappeared.toString());
        }
    }

    protected void clear(Driver driver, WebElement input) {
        input.clear();
    }
}

