/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.collections;

import com.codeborne.selenide.CheckResult;
import com.codeborne.selenide.Driver;
import com.codeborne.selenide.WebElementsCondition;
import com.codeborne.selenide.ex.DoesNotContainTextsError;
import com.codeborne.selenide.ex.ElementNotFound;
import com.codeborne.selenide.impl.CollectionSource;
import com.codeborne.selenide.impl.ElementCommunicator;
import com.codeborne.selenide.impl.Html;
import com.codeborne.selenide.impl.Plugins;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.openqa.selenium.WebElement;

public class ContainExactTextsCaseSensitive
extends WebElementsCondition {
    private static final ElementCommunicator communicator = Plugins.inject(ElementCommunicator.class);
    private final List<String> expectedTexts;

    public ContainExactTextsCaseSensitive(String ... expectedTexts) {
        this(Arrays.asList(expectedTexts));
    }

    public ContainExactTextsCaseSensitive(List<String> expectedTexts) {
        if (expectedTexts.isEmpty()) {
            throw new IllegalArgumentException("No expected texts given");
        }
        this.expectedTexts = Collections.unmodifiableList(expectedTexts);
    }

    @Override
    public CheckResult check(Driver driver, List<WebElement> elements) {
        List<String> actualTexts = communicator.texts(driver, elements);
        List<String> difference = ContainExactTextsCaseSensitive.diff(this.expectedTexts, actualTexts);
        return new CheckResult(difference.isEmpty(), actualTexts);
    }

    @Override
    public void fail(CollectionSource collection, CheckResult lastCheckResult, @Nullable Exception cause, long timeoutMs) {
        List actualTexts = (List)lastCheckResult.requireActualValue();
        if (actualTexts.isEmpty()) {
            throw new ElementNotFound(collection, this.toString(), timeoutMs, (Throwable)cause);
        }
        List<String> difference = ContainExactTextsCaseSensitive.diff(this.expectedTexts, actualTexts);
        throw new DoesNotContainTextsError(collection, this.expectedTexts, actualTexts, difference, this.explanation, timeoutMs, cause);
    }

    private static List<String> diff(List<String> expectedTexts, List<String> actualTexts) {
        ArrayList<String> difference = new ArrayList<String>(expectedTexts.size());
        expectedTexts.forEach(text -> difference.add(Html.text.reduceSpaces((String)text)));
        actualTexts.forEach(text -> difference.remove(Html.text.reduceSpaces((String)text)));
        return difference;
    }

    @Override
    public String toString() {
        return "Contains exact texts case-sensitive " + String.valueOf(this.expectedTexts);
    }
}

