/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide;

import com.codeborne.selenide.WebElementsCondition;
import com.codeborne.selenide.collections.AllMatch;
import com.codeborne.selenide.collections.AnyMatch;
import com.codeborne.selenide.collections.Attributes;
import com.codeborne.selenide.collections.ContainExactTextsCaseSensitive;
import com.codeborne.selenide.collections.ExactTexts;
import com.codeborne.selenide.collections.ExactTextsCaseSensitive;
import com.codeborne.selenide.collections.ExactTextsCaseSensitiveInAnyOrder;
import com.codeborne.selenide.collections.ItemWithText;
import com.codeborne.selenide.collections.ListSize;
import com.codeborne.selenide.collections.NoneMatch;
import com.codeborne.selenide.collections.SizeGreaterThan;
import com.codeborne.selenide.collections.SizeGreaterThanOrEqual;
import com.codeborne.selenide.collections.SizeLessThan;
import com.codeborne.selenide.collections.SizeLessThanOrEqual;
import com.codeborne.selenide.collections.SizeNotEqual;
import com.codeborne.selenide.collections.Texts;
import com.codeborne.selenide.collections.TextsInAnyOrder;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import org.openqa.selenium.WebElement;

public final class CollectionCondition {
    public static WebElementsCondition empty = CollectionCondition.size(0);

    public static WebElementsCondition size(int expectedSize) {
        return new ListSize(expectedSize);
    }

    public static WebElementsCondition sizeGreaterThan(int expectedSize) {
        return new SizeGreaterThan(expectedSize);
    }

    public static WebElementsCondition sizeGreaterThanOrEqual(int expectedSize) {
        return new SizeGreaterThanOrEqual(expectedSize);
    }

    public static WebElementsCondition sizeLessThan(int expectedSize) {
        return new SizeLessThan(expectedSize);
    }

    public static WebElementsCondition sizeLessThanOrEqual(int size) {
        return new SizeLessThanOrEqual(size);
    }

    public static WebElementsCondition sizeNotEqual(int expectedSize) {
        return new SizeNotEqual(expectedSize);
    }

    public static WebElementsCondition texts(String ... expectedTexts) {
        return new Texts(expectedTexts);
    }

    public static WebElementsCondition texts(List<String> expectedTexts) {
        return new Texts(expectedTexts);
    }

    public static WebElementsCondition textsInAnyOrder(String ... expectedTexts) {
        return new TextsInAnyOrder(expectedTexts);
    }

    public static WebElementsCondition textsInAnyOrder(List<String> expectedTexts) {
        return new TextsInAnyOrder(expectedTexts);
    }

    public static WebElementsCondition exactTexts(String ... expectedTexts) {
        return new ExactTexts(expectedTexts);
    }

    public static WebElementsCondition exactTexts(List<String> expectedTexts) {
        return new ExactTexts(expectedTexts);
    }

    public static WebElementsCondition attributes(String attribute, String ... expectedValues) {
        return CollectionCondition.attributes(attribute, Arrays.asList(expectedValues));
    }

    public static WebElementsCondition attributes(String attribute, List<String> expectedValues) {
        return new Attributes(attribute, expectedValues);
    }

    public static WebElementsCondition exactTextsCaseSensitive(String ... expectedTexts) {
        return new ExactTextsCaseSensitive(expectedTexts);
    }

    public static WebElementsCondition exactTextsCaseSensitive(List<String> expectedTexts) {
        return new ExactTextsCaseSensitive(expectedTexts);
    }

    public static WebElementsCondition anyMatch(String description, Predicate<WebElement> predicate) {
        return new AnyMatch(description, predicate);
    }

    public static WebElementsCondition allMatch(String description, Predicate<WebElement> predicate) {
        return new AllMatch(description, predicate);
    }

    public static WebElementsCondition noneMatch(String description, Predicate<WebElement> predicate) {
        return new NoneMatch(description, predicate);
    }

    public static WebElementsCondition itemWithText(String expectedText) {
        return new ItemWithText(expectedText);
    }

    public static WebElementsCondition containExactTextsCaseSensitive(String ... expectedTexts) {
        return new ContainExactTextsCaseSensitive(expectedTexts);
    }

    public static WebElementsCondition containExactTextsCaseSensitive(List<String> expectedTexts) {
        return new ContainExactTextsCaseSensitive(expectedTexts);
    }

    public static WebElementsCondition exactTextsCaseSensitiveInAnyOrder(List<String> expectedTexts) {
        return new ExactTextsCaseSensitiveInAnyOrder(expectedTexts);
    }

    public static WebElementsCondition exactTextsCaseSensitiveInAnyOrder(String ... expectedTexts) {
        return new ExactTextsCaseSensitiveInAnyOrder(expectedTexts);
    }
}

