/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import java.util.function.Supplier;
import org.jspecify.annotations.Nullable;

public record CheckResult(Verdict verdict, @Nullable String message, @Nullable Object actualValue, LocalDateTime timestamp) {
    private static final DateTimeFormatter timeFormat = DateTimeFormatter.ofPattern("HH:mm:ss:SSS");

    public CheckResult(Verdict verdict, @Nullable Object actualValue) {
        this(verdict, null, actualValue, LocalDateTime.now());
    }

    public CheckResult(boolean checkSucceeded, @Nullable Object actualValue) {
        this(checkSucceeded ? Verdict.ACCEPT : Verdict.REJECT, actualValue);
    }

    public static CheckResult rejected(String message, @Nullable Object actualValue) {
        return new CheckResult(Verdict.REJECT, message, actualValue, LocalDateTime.now());
    }

    public static CheckResult accepted() {
        return new CheckResult(Verdict.ACCEPT, null);
    }

    public static CheckResult accepted(@Nullable Object actualValue) {
        return new CheckResult(Verdict.ACCEPT, actualValue);
    }

    @Override
    public String toString() {
        return String.format("%s @ %s%n", this.actualValue, timeFormat.format(this.timestamp));
    }

    public String getMessageOrElse(Supplier<String> defaultMessage) {
        return this.message() == null ? defaultMessage.get() : this.message();
    }

    public <T> @Nullable T getActualValue() {
        return (T)this.actualValue();
    }

    public <T> T getActualValueOrElse(T defaultValue) {
        return (T)(this.actualValue() == null ? defaultValue : this.actualValue());
    }

    public <T> T requireActualValue() {
        return (T)Objects.requireNonNull(this.actualValue());
    }

    public static enum Verdict {
        ACCEPT,
        REJECT;

    }
}

