/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.codeborne.selenide.Driver;
import com.codeborne.selenide.impl.Alias;
import com.codeborne.selenide.impl.CollectionSource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.openqa.selenium.WebElement;

public class WebElementsCollectionWrapper
implements CollectionSource {
    private final List<WebElement> elements;
    private final Driver driver;
    private Alias alias = Alias.NONE;

    public WebElementsCollectionWrapper(Driver driver, Collection<? extends WebElement> elements) {
        this.driver = driver;
        this.elements = new ArrayList<WebElement>(elements);
    }

    @Override
    public List<WebElement> getElements() {
        return this.elements;
    }

    @Override
    public WebElement getElement(int index) {
        return this.elements.get(index);
    }

    @Override
    public String getSearchCriteria() {
        return "$$(" + this.elements.size() + " elements)";
    }

    public String toString() {
        return this.getSearchCriteria();
    }

    @Override
    public String description() {
        return this.alias.getOrElse(() -> this.getSearchCriteria());
    }

    @Override
    public Driver driver() {
        return this.driver;
    }

    @Override
    public Alias getAlias() {
        return this.alias;
    }

    @Override
    public void setAlias(String alias) {
        this.alias = new Alias(alias);
    }
}

