/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.codeborne.selenide.CheckResult;
import com.codeborne.selenide.Driver;
import com.codeborne.selenide.ObjectCondition;
import com.codeborne.selenide.ex.ConditionMetError;
import com.codeborne.selenide.ex.ConditionNotMetError;
import com.codeborne.selenide.ex.UIAssertionError;
import com.codeborne.selenide.logevents.LogEvent;
import com.codeborne.selenide.logevents.SelenideLog;
import com.codeborne.selenide.logevents.SelenideLogger;
import java.time.Duration;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Waiter {
    private static final Logger logger = LoggerFactory.getLogger(Waiter.class);

    public void wait(long timeout, long pollingInterval, Supplier<Boolean> condition) {
        this.sleep(pollingInterval);
        long start = System.currentTimeMillis();
        while (!this.isTimeoutExceeded(timeout, start) && !condition.get().booleanValue()) {
            this.sleep(pollingInterval);
        }
    }

    public <T> void wait(Driver driver, T subject, ObjectCondition<T> condition) {
        this.wait(driver, subject, condition, driver.config().timeout(), driver.config().pollingInterval());
    }

    public <T> void wait(Driver driver, T subject, ObjectCondition<T> condition, Duration timeout) {
        this.wait(driver, subject, condition, timeout.toMillis(), driver.config().pollingInterval());
    }

    private <T> void wait(Driver driver, T subject, ObjectCondition<T> condition, long timeout, long pollingInterval) {
        SelenideLog log = SelenideLogger.beginStep(condition.describe(subject), condition.description());
        CheckResult result = null;
        Exception error = null;
        long start = System.currentTimeMillis();
        while (!this.isTimeoutExceeded(timeout, start)) {
            try {
                result = condition.check(subject);
                if (result.verdict() == CheckResult.Verdict.ACCEPT) {
                    SelenideLogger.commitStep(log, LogEvent.EventStatus.PASS);
                    return;
                }
            }
            catch (Exception e) {
                logger.info("Fail to check condition", (Throwable)e);
                error = e;
            }
            this.sleep(pollingInterval);
        }
        Error failure = UIAssertionError.wrap(driver, (Error)((Object)new ConditionNotMetError(condition, subject, result, error)), timeout);
        SelenideLogger.commitStep(log, failure);
        throw failure;
    }

    public <T> void waitWhile(Driver driver, T subject, ObjectCondition<T> condition) {
        this.waitWhile(driver, subject, condition, driver.config().timeout(), driver.config().pollingInterval());
    }

    public <T> void waitWhile(Driver driver, T subject, ObjectCondition<T> condition, Duration timeout) {
        this.waitWhile(driver, subject, condition, timeout.toMillis(), driver.config().pollingInterval());
    }

    private <T> void waitWhile(Driver driver, T subject, ObjectCondition<T> condition, long timeout, long pollingInterval) {
        SelenideLog log = SelenideLogger.beginStep(subject.toString(), condition.negativeDescription());
        CheckResult result = null;
        Exception error = null;
        long start = System.currentTimeMillis();
        while (!this.isTimeoutExceeded(timeout, start)) {
            try {
                result = condition.check(subject);
                if (result.verdict() == CheckResult.Verdict.REJECT) {
                    SelenideLogger.commitStep(log, LogEvent.EventStatus.PASS);
                    return;
                }
            }
            catch (Exception e) {
                logger.info("Fail to check condition", (Throwable)e);
                error = e;
            }
            this.sleep(pollingInterval);
        }
        Error failure = UIAssertionError.wrap(driver, (Error)((Object)new ConditionMetError(condition, subject, result, error)), timeout);
        SelenideLogger.commitStep(log, failure);
        throw failure;
    }

    private boolean isTimeoutExceeded(long timeout, long start) {
        return System.currentTimeMillis() - start > timeout;
    }

    private void sleep(long milliseconds) {
        try {
            Thread.sleep(milliseconds);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }
}

