/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.codeborne.selenide.Driver;
import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.WebElementCondition;
import com.codeborne.selenide.ex.ElementNotFound;
import com.codeborne.selenide.impl.Alias;
import com.codeborne.selenide.impl.Lazy;
import com.codeborne.selenide.impl.SelenideElementProxy;
import com.codeborne.selenide.impl.WebElementSource;
import java.lang.reflect.Proxy;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.openqa.selenium.WebElement;

public class LazyWebElementSnapshot
extends WebElementSource {
    private final WebElementSource delegate;
    private final Lazy<WebElement> snapshot;

    public static SelenideElement wrap(WebElementSource delegate) {
        return LazyWebElementSnapshot.wrap(SelenideElement.class, delegate);
    }

    public static <T extends SelenideElement> T wrap(Class<T> clazz, WebElementSource delegate) {
        return (T)((SelenideElement)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{clazz}, new SelenideElementProxy(new LazyWebElementSnapshot(delegate))));
    }

    LazyWebElementSnapshot(WebElementSource delegate) {
        this.delegate = delegate;
        this.snapshot = Lazy.lazyEvaluated(() -> delegate.getWebElement());
    }

    @Override
    public Driver driver() {
        return this.delegate.driver();
    }

    @Override
    public WebElement getWebElement() {
        return this.snapshot.get();
    }

    @Override
    public String getSearchCriteria() {
        return this.delegate.getSearchCriteria();
    }

    @Override
    public final void setAlias(String alias) {
        this.delegate.setAlias(alias);
    }

    @Override
    public Alias getAlias() {
        return this.delegate.getAlias();
    }

    @Override
    public String description() {
        return this.delegate.description();
    }

    @Override
    public String toString() {
        return this.delegate.toString();
    }

    @Override
    public SelenideElement find(SelenideElement proxy, Object arg, int index) {
        return this.delegate.find(proxy, arg, index);
    }

    @Override
    public List<WebElement> findAll() throws IndexOutOfBoundsException {
        return this.delegate.findAll();
    }

    @Override
    public ElementNotFound createElementNotFoundError(WebElementCondition condition, @Nullable Throwable cause) {
        return this.delegate.createElementNotFoundError(condition, cause);
    }
}

