/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.codeborne.selenide.Condition;
import com.codeborne.selenide.Driver;
import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.WebElementCondition;
import com.codeborne.selenide.ex.ElementNotFound;
import com.codeborne.selenide.impl.SelenideElementProxy;
import com.codeborne.selenide.impl.WebElementSource;
import java.lang.reflect.Proxy;
import org.jspecify.annotations.Nullable;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebElement;

public class JSElementFinder
extends WebElementSource {
    private final Driver driver;
    private final String description;
    private final WebElementSource parent;
    private final String js;

    public static <T extends SelenideElement> T wrap(Class<T> clazz, Driver driver, String description, WebElementSource parent, String js) {
        return (T)((SelenideElement)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{clazz}, new SelenideElementProxy(new JSElementFinder(driver, description, parent, js))));
    }

    JSElementFinder(Driver driver, String description, WebElementSource parent, String js) {
        this.driver = driver;
        this.description = description;
        this.parent = parent;
        this.js = js;
    }

    @Override
    public Driver driver() {
        return this.driver;
    }

    @Override
    public WebElement getWebElement() throws NoSuchElementException, IndexOutOfBoundsException {
        WebElement webElement = (WebElement)this.driver.executeJavaScript(this.js, this.parent.getWebElement());
        if (webElement == null) {
            throw new NoSuchElementException("Cannot locate an element " + this.description());
        }
        return webElement;
    }

    @Override
    public ElementNotFound createElementNotFoundError(WebElementCondition condition, @Nullable Throwable cause) {
        this.parent.checkCondition("", Condition.exist, false);
        return super.createElementNotFoundError(condition, cause);
    }

    @Override
    public String getSearchCriteria() {
        return this.description;
    }

    @Override
    public String toString() {
        return "{" + this.description() + "}";
    }
}

