/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.jspecify.annotations.Nullable;

public class HttpHelper {
    private static final Pattern FILENAME_IN_CONTENT_DISPOSITION_HEADER = Pattern.compile(".*filename\\*? *= *\"?((.+)'')?([^\";?]*)\"?(;charset=(.*))?.*", 2);
    private static final Pattern FILENAME_FORBIDDEN_CHARACTERS = Pattern.compile("[#%&{}/\\\\<>*?$!'\":@+`|=]");

    public Optional<String> getFileNameFromContentDisposition(Map<String, String> headers) {
        return this.getFileNameFromContentDisposition(headers.entrySet());
    }

    public Optional<String> getFileNameFromContentDisposition(Collection<Map.Entry<String, String>> headers) {
        for (Map.Entry<String, String> header : headers) {
            Optional<String> fileName = this.getFileNameFromContentDisposition(header.getKey(), header.getValue());
            if (!fileName.isPresent()) continue;
            return fileName;
        }
        return Optional.empty();
    }

    public Optional<String> getFileNameFromContentDisposition(String headerName, @Nullable String headerValue) {
        if (!"Content-Disposition".equalsIgnoreCase(headerName) || headerValue == null) {
            return Optional.empty();
        }
        Matcher regex = FILENAME_IN_CONTENT_DISPOSITION_HEADER.matcher(headerValue);
        if (!regex.matches()) {
            return Optional.empty();
        }
        String fileNamePart = regex.replaceFirst("$3");
        String encodingPart = (String)StringUtils.defaultIfEmpty((CharSequence)regex.replaceFirst("$2"), (CharSequence)regex.replaceFirst("$5"));
        String filename = this.decodeHttpHeader(fileNamePart, encodingPart);
        try {
            return Optional.of(new String(Base64.getDecoder().decode(filename), StandardCharsets.UTF_8));
        }
        catch (IllegalArgumentException notBase64Encoded) {
            return Optional.of(filename);
        }
    }

    private String decodeHttpHeader(String encoded, String encoding) {
        try {
            return URLDecoder.decode(encoded, (String)StringUtils.defaultIfEmpty((CharSequence)encoding, (CharSequence)"UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public String getFileName(String url) {
        return this.normalize(this.trimQuery(FilenameUtils.getName((String)url)));
    }

    private String trimQuery(String filenameWithQuery) {
        return filenameWithQuery.contains("?") ? StringUtils.left((String)filenameWithQuery, (int)filenameWithQuery.indexOf(63)) : filenameWithQuery;
    }

    public String normalize(String fileName) {
        return FILENAME_FORBIDDEN_CHARACTERS.matcher(fileName).replaceAll("_").replace(' ', '+');
    }
}

