/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import java.util.Locale;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class Html {
    private static final Pattern REGEX_SPACES = Pattern.compile("[\\s\\p{Zs}\u200b\u200c\u200d\u2060]+");
    public static Html text = new Html();

    public boolean matches(String text, String regex) {
        return Pattern.compile(regex, 32).matcher(text).matches();
    }

    public boolean matchesSubstring(String text, String regex) {
        return Pattern.compile(".*" + regex + ".*", 32).matcher(text).matches();
    }

    public boolean contains(String text, String subtext) {
        String expected = this.reduceSpaces(subtext.toLowerCase(Locale.ROOT));
        Html.verifyNotEmptySubstring(expected);
        return this.reduceSpaces(text.toLowerCase(Locale.ROOT)).contains(expected);
    }

    private static void verifyNotEmptySubstring(String expectedText) {
        if (StringUtils.isEmpty((CharSequence)expectedText)) {
            throw new IllegalArgumentException("Expected substring must not be null or empty string. Consider setting Configuration.textCheck = FULL_TEXT;");
        }
    }

    public boolean containsCaseSensitive(String text, String subtext) {
        return this.reduceSpaces(text).contains(this.reduceSpaces(subtext));
    }

    public boolean equals(String text, String subtext) {
        return this.reduceSpaces(text).equalsIgnoreCase(this.reduceSpaces(subtext));
    }

    public boolean equalsCaseSensitive(String text, String subtext) {
        return this.reduceSpaces(text).equals(this.reduceSpaces(subtext));
    }

    public String reduceSpaces(String text) {
        return REGEX_SPACES.matcher(text).replaceAll(" ").trim();
    }
}

