/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.codeborne.selenide.Condition;
import com.codeborne.selenide.Container;
import com.codeborne.selenide.Driver;
import com.codeborne.selenide.ex.ElementNotFound;
import com.codeborne.selenide.ex.PageObjectException;
import com.codeborne.selenide.ex.UIAssertionError;
import com.codeborne.selenide.impl.Alias;
import com.codeborne.selenide.impl.CollectionSource;
import com.codeborne.selenide.impl.PageObjectFactory;
import com.codeborne.selenide.impl.SelenideAnnotations;
import com.codeborne.selenide.impl.WebElementSource;
import com.codeborne.selenide.impl.WebElementWrapper;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.AbstractList;
import org.jspecify.annotations.Nullable;
import org.openqa.selenium.NoSuchElementException;

public class ElementsContainerCollection<T extends Container>
extends AbstractList<T> {
    private final PageObjectFactory pageFactory;
    private final Driver driver;
    private final @Nullable Field field;
    private final Class<T> listType;
    private final Type[] genericTypes;
    private final CollectionSource collection;

    public ElementsContainerCollection(PageObjectFactory pageFactory, Driver driver, @Nullable Field field, Class<T> listType, Type[] genericTypes, CollectionSource collection) {
        this.pageFactory = pageFactory;
        this.driver = driver;
        this.field = field;
        this.listType = listType;
        this.genericTypes = genericTypes;
        this.collection = collection;
    }

    @Override
    public T get(int index) {
        String searchCriteria = String.format("%s[%s]", this.collection.getSearchCriteria(), index);
        WebElementWrapper self = new WebElementWrapper(this.driver, this.collection.getElement(index), searchCriteria, SelenideAnnotations.isShadowRoot(this.field, this.listType));
        try {
            return this.initElementsContainer(self);
        }
        catch (ReflectiveOperationException e) {
            throw this.pageObjectException(e);
        }
    }

    private T initElementsContainer(WebElementSource self) throws ReflectiveOperationException {
        return (T)this.pageFactory.initElementsContainer(this.driver, this.field, self, this.listType, this.genericTypes);
    }

    private PageObjectException pageObjectException(ReflectiveOperationException e) {
        String message = this.field == null ? "Failed to initialize type " + this.listType.getName() : "Failed to initialize field " + String.valueOf(this.field);
        return new PageObjectException(message, e);
    }

    @Override
    public int size() {
        try {
            return this.collection.getElements().size();
        }
        catch (NoSuchElementException e) {
            throw UIAssertionError.wrap(this.driver, (Error)((Object)new ElementNotFound(Alias.NONE, this.collection.getSearchCriteria(), Condition.exist, (Throwable)e)), 0L);
        }
    }

    @Override
    public String toString() {
        return this.collection.description();
    }
}

