/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.codeborne.selenide.Config;
import com.codeborne.selenide.impl.FileHelper;
import com.codeborne.selenide.impl.Randomizer;
import java.io.File;

public class Downloader {
    private final Randomizer random;

    public Downloader() {
        this(new Randomizer());
    }

    public Downloader(Randomizer random) {
        this.random = random;
    }

    public String randomFileName() {
        return this.random.text();
    }

    public File prepareTargetFile(Config config, String fileName) {
        File uniqueFolder = this.prepareTargetFolder(config);
        return new File(uniqueFolder, fileName);
    }

    public File prepareTargetFolder(Config config) {
        File parent = new File(config.downloadsFolder()).getAbsoluteFile();
        File uniqueFolder = new File(parent, this.random.text());
        if (uniqueFolder.exists()) {
            throw new IllegalStateException("Unbelievable! Unique folder already exists: " + String.valueOf(uniqueFolder));
        }
        FileHelper.ensureFolderExists(uniqueFolder);
        return uniqueFolder;
    }
}

