/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.codeborne.selenide.Config;
import com.codeborne.selenide.Driver;
import com.codeborne.selenide.files.DownloadAction;
import com.codeborne.selenide.files.FileFilter;
import com.codeborne.selenide.impl.Waiter;
import com.codeborne.selenide.impl.WebElementSource;
import com.codeborne.selenide.proxy.FileDownloadFilter;
import com.codeborne.selenide.proxy.SelenideProxyServer;
import java.io.File;
import java.util.function.Supplier;
import org.openqa.selenium.WebElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DownloadFileWithProxyServer {
    private static final Logger log = LoggerFactory.getLogger(DownloadFileWithProxyServer.class);
    private final Waiter waiter;

    DownloadFileWithProxyServer(Waiter waiter) {
        this.waiter = waiter;
    }

    public DownloadFileWithProxyServer() {
        this(new Waiter());
    }

    public File download(WebElementSource anyClickableElement, WebElement clickable, long timeout, FileFilter fileFilter, DownloadAction action) {
        return this.clickAndInterceptFileByProxyServer(anyClickableElement, clickable, timeout, fileFilter, action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File clickAndInterceptFileByProxyServer(WebElementSource anyClickableElement, WebElement clickable, long timeout, FileFilter fileFilter, DownloadAction action) {
        Driver driver = anyClickableElement.driver();
        Config config = driver.config();
        if (!config.proxyEnabled()) {
            throw new IllegalStateException("Cannot download file: proxy server is not enabled. Setup proxyEnabled");
        }
        SelenideProxyServer proxyServer = driver.getProxy();
        FileDownloadFilter filter = (FileDownloadFilter)proxyServer.responseFilter("download");
        if (filter == null) {
            throw new IllegalStateException("Cannot download file: download filter is not activated");
        }
        filter.activate();
        try {
            long pollingInterval = Math.max(config.pollingInterval(), 50L);
            this.waitForPreviousDownloadsCompletion(filter, timeout, pollingInterval);
            filter.reset();
            action.perform(driver, clickable);
            this.waitForNewDownloads(filter, fileFilter, timeout, pollingInterval);
            if (log.isInfoEnabled()) {
                log.info("Downloaded {}", (Object)filter.downloads().filesAsString());
                log.info("Just in case, intercepted {}", (Object)filter.responsesAsString());
            }
            File file = filter.downloads().firstDownloadedFile(timeout, fileFilter);
            return file;
        }
        finally {
            filter.deactivate();
        }
    }

    private void waitForNewDownloads(FileDownloadFilter filter, FileFilter fileFilter, long timeout, long pollingInterval) {
        this.waiter.wait(timeout, pollingInterval, () -> !filter.downloads().files(fileFilter).isEmpty());
    }

    private void waitForPreviousDownloadsCompletion(FileDownloadFilter filter, long timeout, long pollingInterval) {
        this.waiter.wait(timeout, pollingInterval, new PreviousDownloadsCompleted(filter));
    }

    private static class PreviousDownloadsCompleted
    implements Supplier<Boolean> {
        private final FileDownloadFilter filter;
        private int downloadsCount = -1;

        PreviousDownloadsCompleted(FileDownloadFilter filter) {
            this.filter = filter;
        }

        @Override
        public Boolean get() {
            int previousCount = this.downloadsCount;
            this.downloadsCount = this.filter.downloads().size();
            return this.downloadsCount == previousCount;
        }
    }
}

