/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.codeborne.selenide.CheckResult;
import com.codeborne.selenide.Driver;
import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.WebElementCondition;
import com.codeborne.selenide.impl.CollectionSource;
import com.codeborne.selenide.impl.SelenideElementProxy;
import com.codeborne.selenide.impl.WebElementSource;
import java.lang.reflect.Proxy;
import java.util.List;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebElement;

public class CollectionElementByCondition
extends WebElementSource {
    private final CollectionSource collection;
    private final WebElementCondition condition;

    public static <T extends SelenideElement> T wrap(CollectionSource collection, WebElementCondition condition, Class<T> clazz) {
        return (T)((SelenideElement)Proxy.newProxyInstance(collection.getClass().getClassLoader(), new Class[]{clazz}, new SelenideElementProxy(new CollectionElementByCondition(collection, condition))));
    }

    CollectionElementByCondition(CollectionSource collection, WebElementCondition condition) {
        this.collection = collection;
        this.condition = condition;
    }

    @Override
    public Driver driver() {
        return this.collection.driver();
    }

    @Override
    public WebElement getWebElement() {
        List<WebElement> list = this.collection.getElements();
        for (WebElement element : list) {
            if (this.condition.check(this.driver(), element).verdict() != CheckResult.Verdict.ACCEPT) continue;
            return element;
        }
        throw new NoSuchElementException("Cannot locate an element " + this.description());
    }

    @Override
    public String getSearchCriteria() {
        return this.collection.getSearchCriteria() + ".findBy(" + String.valueOf(this.condition) + ")";
    }

    @Override
    public String description() {
        return this.getAlias().getOrElse(() -> this.collection.shortDescription() + ".findBy(" + String.valueOf(this.condition) + ")");
    }
}

