/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CiReportUrl {
    private static final Logger log = LoggerFactory.getLogger(CiReportUrl.class);

    public @Nullable String getReportsUrl(@Nullable String reportsUrl) {
        if (!this.isEmpty(reportsUrl)) {
            log.debug("Using variable selenide.reportsUrl={}", (Object)reportsUrl);
            return this.resolveUrlSource(reportsUrl, new Object[0]);
        }
        String jenkinsReportsUrl = this.getJenkinsReportsUrl();
        if (!this.isEmpty(jenkinsReportsUrl)) {
            log.debug("Using Jenkins BUILD_URL: {}", (Object)jenkinsReportsUrl);
            return jenkinsReportsUrl;
        }
        String teamCityUrl = this.getTeamCityUrl();
        if (!this.isEmpty(teamCityUrl)) {
            log.debug("Using Teamcity artifacts url: {}", (Object)teamCityUrl);
            return teamCityUrl;
        }
        log.debug("Variable selenide.reportsUrl not found");
        return reportsUrl;
    }

    private @Nullable String getTeamCityUrl() {
        String url = System.getProperty("teamcity.serverUrl");
        String build_type = System.getProperty("teamcity.buildType.id");
        String build_number = System.getProperty("build.number");
        if (this.isEmpty(build_type) || this.isEmpty(build_number) || this.isEmpty(url)) {
            return null;
        }
        return this.resolveUrlSource("%s/repository/download/%s/%s:id/", url, build_type, build_number);
    }

    private @Nullable String getJenkinsReportsUrl() {
        String build_url = System.getProperty("BUILD_URL");
        if (!this.isEmpty(build_url)) {
            String workspace = System.getProperty("WORKSPACE", System.getenv("WORKSPACE"));
            Object reportRelativePath = "";
            if (!this.isEmpty(workspace)) {
                Path pathAbsoluteReportsFolder = Paths.get("", new String[0]).normalize().toAbsolutePath();
                Path pathAbsoluteWorkSpace = Paths.get(workspace, new String[0]).normalize().toAbsolutePath();
                Path pathRelative = pathAbsoluteWorkSpace.relativize(pathAbsoluteReportsFolder);
                reportRelativePath = pathRelative.toString().replace('\\', '/') + "/";
            }
            return this.resolveUrlSource("%s/artifact/%s", build_url, reportRelativePath);
        }
        return null;
    }

    private @Nullable String resolveUrlSource(String base, Object ... format) {
        if (format.length != 0) {
            base = String.format(base, format);
        }
        try {
            return new URI(base).normalize().toURL().toString();
        }
        catch (Exception e) {
            log.error("Variable selenide.reportsUrl is incorrect: {}", (Object)base, (Object)e);
            return null;
        }
    }

    private boolean isEmpty(@Nullable String s) {
        return s == null || s.trim().isEmpty();
    }
}

