/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.files;

import java.io.File;
import java.util.Map;
import org.jspecify.annotations.Nullable;

public class DownloadedFile {
    private final File file;
    private final Map<String, String> headers;

    public DownloadedFile(File file, Map<String, String> headers) {
        this.file = file;
        this.headers = headers;
    }

    public File getFile() {
        return this.file;
    }

    public boolean hasContentDispositionHeader() {
        return this.headers.containsKey("content-disposition");
    }

    public @Nullable String getContentType() {
        return this.headers.get("content-type");
    }

    public String toString() {
        return String.format("%s (modified %s ms ago)", this.file.getName(), System.currentTimeMillis() - this.file.lastModified());
    }
}

