/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.conditions.sessionstorage;

import com.codeborne.selenide.CheckResult;
import com.codeborne.selenide.ObjectCondition;
import com.codeborne.selenide.SessionStorage;
import org.jspecify.annotations.Nullable;

public class Item
implements ObjectCondition<SessionStorage> {
    private final String item;

    public Item(String item) {
        this.item = item;
    }

    @Override
    public String description() {
        return String.format("should have item '%s'", this.item);
    }

    @Override
    public String negativeDescription() {
        return String.format("should not have item '%s'", this.item);
    }

    private String actualValue(SessionStorage sessionStorage) {
        return sessionStorage.getItems().toString();
    }

    @Override
    public @Nullable String expectedValue() {
        return this.item;
    }

    @Override
    public CheckResult check(SessionStorage sessionStorage) {
        boolean met = sessionStorage.containsItem(this.item);
        return this.result(sessionStorage, met, this.actualValue(sessionStorage));
    }

    @Override
    public String describe(SessionStorage sessionStorage) {
        return "sessionStorage";
    }
}

