/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.conditions;

import com.codeborne.selenide.CheckResult;
import com.codeborne.selenide.Driver;
import com.codeborne.selenide.WebElementCondition;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.WebElement;

public class PseudoElementPropertyWithValue
extends WebElementCondition {
    static final String JS_CODE = "return window.getComputedStyle(arguments[0], arguments[1]).getPropertyValue(arguments[2]);";
    private final String pseudoElementName;
    private final String propertyName;
    private final String expectedPropertyValue;

    public PseudoElementPropertyWithValue(String pseudoElementName, String propertyName, String expectedPropertyValue) {
        super("pseudo-element");
        this.pseudoElementName = pseudoElementName;
        this.propertyName = propertyName;
        this.expectedPropertyValue = expectedPropertyValue;
    }

    @Override
    public CheckResult check(Driver driver, WebElement element) {
        String value = this.getPseudoElementPropertyValue(driver, element);
        return new CheckResult(StringUtils.defaultString((String)this.expectedPropertyValue).equalsIgnoreCase(value), (Object)this.actualValue(value));
    }

    private String actualValue(String pseudoElementValue) {
        return String.format("%s {%s: %s;}", this.pseudoElementName, this.propertyName, pseudoElementValue);
    }

    @Override
    public String toString() {
        return String.format("%s %s {%s: %s;}", this.getName(), this.pseudoElementName, this.propertyName, this.expectedPropertyValue);
    }

    private String getPseudoElementPropertyValue(Driver driver, WebElement element) {
        String propertyValue = (String)driver.executeJavaScript(JS_CODE, element, this.pseudoElementName, this.propertyName);
        return propertyValue == null ? "" : propertyValue;
    }
}

