/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.conditions;

import com.codeborne.selenide.conditions.TextCondition;
import java.util.Collection;
import java.util.Objects;

abstract class MultipleTextsCondition
extends TextCondition {
    protected final Collection<String> targets;

    protected MultipleTextsCondition(String name, Collection<String> targets, BlankPolicy blankPolicy) {
        super(name, targets.toString());
        if (targets.isEmpty()) {
            throw new IllegalArgumentException("No expected texts given");
        }
        if (targets.stream().anyMatch(target -> Objects.isNull(target))) {
            throw new IllegalArgumentException("The expected texts should not contain null");
        }
        if (blankPolicy == BlankPolicy.BLANK_FORBIDDEN && targets.stream().anyMatch(target -> target.isBlank())) {
            throw new IllegalArgumentException("The expected texts should not contain blank strings");
        }
        this.targets = targets;
    }

    protected static enum BlankPolicy {
        BLANK_ALLOWED,
        BLANK_FORBIDDEN;

    }
}

