/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.conditions;

import com.codeborne.selenide.CheckResult;
import com.codeborne.selenide.Driver;
import com.codeborne.selenide.WebElementCondition;
import org.apache.commons.lang3.StringUtils;
import org.jspecify.annotations.Nullable;
import org.openqa.selenium.WebElement;

public class CssValue
extends WebElementCondition {
    private final String propertyName;
    private final @Nullable String expectedValue;

    public CssValue(String propertyName, @Nullable String expectedValue) {
        super("css value");
        this.propertyName = propertyName;
        this.expectedValue = expectedValue;
    }

    @Override
    public CheckResult check(Driver driver, WebElement element) {
        String actualCssValue = element.getCssValue(this.propertyName);
        boolean matches = StringUtils.defaultString((String)this.expectedValue).equalsIgnoreCase(StringUtils.defaultString((String)actualCssValue));
        return new CheckResult(matches, (Object)String.format("%s=%s", this.propertyName, actualCssValue));
    }

    @Override
    public String toString() {
        return this.getName() + " " + this.propertyName + "=" + this.expectedValue;
    }
}

