/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.commands;

import com.codeborne.selenide.Command;
import com.codeborne.selenide.Condition;
import com.codeborne.selenide.Driver;
import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.commands.Util;
import com.codeborne.selenide.ex.ElementNotFound;
import com.codeborne.selenide.ex.InvalidStateError;
import com.codeborne.selenide.impl.Arguments;
import com.codeborne.selenide.impl.JavaScript;
import com.codeborne.selenide.impl.WebElementSource;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jspecify.annotations.Nullable;
import org.openqa.selenium.WebElement;

public class SelectOptionContainingText
implements Command<Void> {
    private static final JavaScript selectOptionByPartialText = new JavaScript("select-options-by-partial-text.js");

    @Override
    public @Nullable Void execute(SelenideElement proxy, WebElementSource selectField, Object @Nullable [] args) {
        Arguments arguments = new Arguments(args);
        List<String> texts = Util.merge(Objects.requireNonNull((String)arguments.nth(0)), Objects.requireNonNull((String[])arguments.nth(1)));
        Driver driver = selectField.driver();
        WebElement webElement = selectField.getWebElement();
        Map error = Objects.requireNonNull((Map)selectOptionByPartialText.execute(driver, webElement, texts));
        if (error.containsKey("nonSelect")) {
            throw new IllegalArgumentException("Cannot select option from a non-select element");
        }
        if (error.containsKey("disabledSelect")) {
            throw new InvalidStateError(selectField.description(), "Cannot select option in a disabled select");
        }
        if (error.containsKey("disabledOptions")) {
            List text = (List)Util.cast(error.get("disabledOptions"));
            String elementDescription = String.format("%s/option[text containing:%s]", selectField.description(), Util.arrayToString(text));
            throw new InvalidStateError(elementDescription, "Cannot select a disabled option");
        }
        if (error.containsKey("optionsNotFound")) {
            List text = (List)Util.cast(error.get("optionsNotFound"));
            String elementDescription = String.format("%s/option[text containing:%s]", selectField.getSearchCriteria(), Util.arrayToString(text));
            throw new ElementNotFound(selectField.getAlias(), elementDescription, Condition.exist);
        }
        return null;
    }
}

