/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide;

import com.codeborne.selenide.AuthenticationType;
import com.codeborne.selenide.Browser;
import com.codeborne.selenide.Clipboard;
import com.codeborne.selenide.ClipboardService;
import com.codeborne.selenide.Conditional;
import com.codeborne.selenide.Config;
import com.codeborne.selenide.Container;
import com.codeborne.selenide.Credentials;
import com.codeborne.selenide.DownloadsFolder;
import com.codeborne.selenide.Driver;
import com.codeborne.selenide.ElementsCollection;
import com.codeborne.selenide.LocalStorage;
import com.codeborne.selenide.Modal;
import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.SelenideTargetLocator;
import com.codeborne.selenide.SelenideWait;
import com.codeborne.selenide.SessionStorage;
import com.codeborne.selenide.SharedDownloadsFolder;
import com.codeborne.selenide.WebDriverConditional;
import com.codeborne.selenide.WebDriverLogs;
import com.codeborne.selenide.commands.Util;
import com.codeborne.selenide.drivercommands.LazyDriver;
import com.codeborne.selenide.drivercommands.Navigator;
import com.codeborne.selenide.drivercommands.WebDriverWrapper;
import com.codeborne.selenide.files.FileFilters;
import com.codeborne.selenide.impl.DownloadFileWithHttpRequest;
import com.codeborne.selenide.impl.ElementFinder;
import com.codeborne.selenide.impl.JavaScript;
import com.codeborne.selenide.impl.Lazy;
import com.codeborne.selenide.impl.PageObjectFactory;
import com.codeborne.selenide.impl.Plugins;
import com.codeborne.selenide.impl.ScreenShotLaboratory;
import com.codeborne.selenide.impl.WebElementWrapper;
import com.codeborne.selenide.logevents.SelenideLogger;
import com.codeborne.selenide.proxy.SelenideProxyServer;
import com.codeborne.selenide.selector.FocusedElementLocator;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jspecify.annotations.Nullable;
import org.openqa.selenium.By;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.remote.SessionId;
import org.openqa.selenium.support.events.WebDriverListener;

public class SelenideDriver {
    private static final JavaScript zoomJs = new JavaScript("zoom.js");
    private static final Navigator navigator = new Navigator();
    private static final ScreenShotLaboratory screenshots = Plugins.inject(new ScreenShotLaboratory[0]);
    private final Config config;
    private final Driver driver;
    private static final PageObjectFactory pageFactory = Plugins.inject(PageObjectFactory.class);
    private static final Lazy<DownloadFileWithHttpRequest> downloadFileWithHttpRequest = Lazy.lazyEvaluated(DownloadFileWithHttpRequest::new);

    public SelenideDriver(Config config) {
        this(config, Collections.emptyList());
    }

    public SelenideDriver(Config config, List<WebDriverListener> listeners) {
        this(config, new LazyDriver(config, null, listeners));
    }

    public SelenideDriver(Config config, Driver driver) {
        this.config = config;
        this.driver = driver;
    }

    public SelenideDriver(Config config, WebDriver webDriver, @Nullable SelenideProxyServer selenideProxy) {
        this(config, webDriver, selenideProxy, new SharedDownloadsFolder(config.downloadsFolder()));
    }

    public SelenideDriver(Config config, WebDriver webDriver, @Nullable SelenideProxyServer selenideProxy, DownloadsFolder browserDownloadsFolder) {
        this.config = config;
        this.driver = new WebDriverWrapper(config, webDriver, selenideProxy, browserDownloadsFolder);
    }

    public Config config() {
        return this.config;
    }

    public Driver driver() {
        return this.driver;
    }

    public void open() {
        navigator.open(this);
    }

    public void open(String relativeOrAbsoluteUrl) {
        navigator.open(this, relativeOrAbsoluteUrl);
    }

    public void open(URL absoluteUrl) {
        navigator.open(this, absoluteUrl);
    }

    public void open(String relativeOrAbsoluteUrl, String domain, String login, String password) {
        navigator.open(this, relativeOrAbsoluteUrl, domain, login, password);
    }

    public void open(String relativeOrAbsoluteUrl, AuthenticationType authenticationType, Credentials credentials) {
        navigator.open(this, relativeOrAbsoluteUrl, authenticationType, credentials);
    }

    public void open(URL absoluteUrl, String domain, String login, String password) {
        navigator.open(this, absoluteUrl, domain, login, password);
    }

    public <PageObjectClass> PageObjectClass open(String relativeOrAbsoluteUrl, Class<PageObjectClass> pageObjectClassClass) {
        this.open(relativeOrAbsoluteUrl);
        return this.page((T)pageObjectClassClass);
    }

    public <PageObjectClass> PageObjectClass open(URL absoluteUrl, Class<PageObjectClass> pageObjectClassClass) {
        this.open(absoluteUrl);
        return this.page((T)pageObjectClassClass);
    }

    public <PageObjectClass> PageObjectClass open(String relativeOrAbsoluteUrl, String domain, String login, String password, Class<PageObjectClass> pageObjectClassClass) {
        this.open(relativeOrAbsoluteUrl, domain, login, password);
        return this.page((T)pageObjectClassClass);
    }

    public <PageObjectClass> PageObjectClass open(URL absoluteUrl, String domain, String login, String password, Class<PageObjectClass> pageObjectClassClass) {
        this.open(absoluteUrl, domain, login, password);
        return this.page((T)pageObjectClassClass);
    }

    public <PageObjectClass> PageObjectClass page(Class<PageObjectClass> pageObjectClass) {
        return pageFactory.page(this.driver(), pageObjectClass);
    }

    @SafeVarargs
    public final <PageObjectClass> PageObjectClass page(PageObjectClass ... reified) {
        return pageFactory.page(this.driver(), Util.classOf(reified));
    }

    public <PageObjectClass, T extends PageObjectClass> PageObjectClass page(T pageObject) {
        return pageFactory.page(this.driver(), pageObject);
    }

    public <ContainerClass extends Container> ContainerClass container(WebElement webElement, Class<ContainerClass> containerClass) {
        return pageFactory.createElementsContainer(this.driver(), webElement, containerClass, containerClass.getGenericInterfaces());
    }

    public <ContainerClass extends Container> ContainerClass container(By seleniumSelector, Class<ContainerClass> containerClass) {
        return pageFactory.createElementsContainer(this.driver(), seleniumSelector, 0, containerClass, containerClass.getGenericInterfaces());
    }

    public <ContainerClass extends Container> ContainerClass container(By seleniumSelector, int index, Class<ContainerClass> containerClass) {
        return pageFactory.createElementsContainer(this.driver(), seleniumSelector, index, containerClass, containerClass.getGenericInterfaces());
    }

    public <ContainerClass extends Container> ContainerClass container(String cssSelector, Class<ContainerClass> containerClass) {
        return this.container(By.cssSelector((String)cssSelector), containerClass);
    }

    public <ContainerClass extends Container> ContainerClass container(String cssSelector, int index, Class<ContainerClass> containerClass) {
        return this.container(By.cssSelector((String)cssSelector), index, containerClass);
    }

    public <ContainerClass extends Container> ContainerClass $x(String xpathExpression, Class<ContainerClass> containerClass) {
        return this.container(By.xpath((String)xpathExpression), containerClass);
    }

    public <ContainerClass extends Container> List<ContainerClass> containers(Collection<? extends WebElement> elements, Class<ContainerClass> containerClass) {
        return pageFactory.createElementsContainerList(this.driver(), elements, containerClass, containerClass.getGenericInterfaces());
    }

    public <ContainerClass extends Container> List<ContainerClass> containers(By seleniumSelector, Class<ContainerClass> containerClass) {
        return pageFactory.createElementsContainerList(this.driver(), seleniumSelector, containerClass, containerClass.getGenericInterfaces());
    }

    public <ContainerClass extends Container> List<ContainerClass> containers(String cssSelector, Class<ContainerClass> containerClass) {
        return this.containers(By.cssSelector((String)cssSelector), containerClass);
    }

    public <ContainerClass extends Container> List<ContainerClass> $$x(String xpathExpression, Class<ContainerClass> containerClass) {
        return this.containers(By.xpath((String)xpathExpression), containerClass);
    }

    public void refresh() {
        navigator.refresh(this.driver());
    }

    public void back() {
        navigator.back(this.driver());
    }

    public void forward() {
        navigator.forward(this.driver());
    }

    public void updateHash(String hash) {
        SelenideLogger.run("updateHash", hash, () -> {
            String localHash = hash.charAt(0) == '#' ? hash.substring(1) : hash;
            this.executeJavaScript("window.location.hash='" + localHash + "'", new Object[0]);
        });
    }

    public Browser browser() {
        return this.driver().browser();
    }

    public SelenideProxyServer getProxy() {
        return this.driver().getProxy();
    }

    public boolean hasWebDriverStarted() {
        return this.driver().hasWebDriverStarted();
    }

    public WebDriver getWebDriver() {
        return this.driver.getWebDriver();
    }

    @CanIgnoreReturnValue
    public WebDriver getAndCheckWebDriver() {
        return this.driver.getAndCheckWebDriver();
    }

    public void clearCookies() {
        SelenideLogger.run("clearCookies", "", () -> this.driver().clearCookies());
    }

    public void close() {
        this.driver.close();
    }

    @CanIgnoreReturnValue
    public <T> @Nullable T executeJavaScript(String jsCode, Object ... arguments) {
        return this.driver().executeJavaScript(jsCode, arguments);
    }

    @CanIgnoreReturnValue
    public <T> @Nullable T executeAsyncJavaScript(String jsCode, Object ... arguments) {
        return this.driver().executeAsyncJavaScript(jsCode, arguments);
    }

    public SelenideElement getFocusedElement() {
        return this.$(new FocusedElementLocator());
    }

    public String getSelectedText() {
        return Objects.requireNonNull((String)this.executeJavaScript("return window.getSelection().toString()", new Object[0]));
    }

    @CanIgnoreReturnValue
    public String copy() {
        String selectedText = this.getSelectedText();
        this.getClipboard().setText(selectedText);
        return selectedText;
    }

    public SelenideWait Wait() {
        return new SelenideWait(this.getWebDriver(), this.config().timeout(), this.config().pollingInterval());
    }

    public void zoom(double factor) {
        zoomJs.execute(this.driver(), factor);
    }

    public @Nullable String title() {
        return this.getWebDriver().getTitle();
    }

    public SelenideElement $(WebElement webElement) {
        return WebElementWrapper.wrap(this.driver(), webElement);
    }

    public SelenideElement $(String cssSelector) {
        return this.find(cssSelector);
    }

    public SelenideElement find(String cssSelector) {
        return this.find(By.cssSelector((String)cssSelector));
    }

    public SelenideElement $x(String xpathExpression) {
        return this.find(By.xpath((String)xpathExpression));
    }

    public SelenideElement $(By seleniumSelector) {
        return this.find(seleniumSelector);
    }

    public SelenideElement $(By seleniumSelector, int index) {
        return this.find(seleniumSelector, index);
    }

    public SelenideElement $(String cssSelector, int index) {
        return ElementFinder.wrap(this.driver(), cssSelector, index);
    }

    public SelenideElement find(By criteria) {
        return ElementFinder.wrap(this.driver(), null, criteria, 0);
    }

    public SelenideElement find(By criteria, int index) {
        return ElementFinder.wrap(this.driver(), null, criteria, index);
    }

    public ElementsCollection $$(Collection<? extends WebElement> elements) {
        return new ElementsCollection(this.driver(), elements);
    }

    public ElementsCollection $$(String cssSelector) {
        return new ElementsCollection(this.driver(), cssSelector);
    }

    public ElementsCollection $$x(String xpathExpression) {
        return this.$$(By.xpath((String)xpathExpression));
    }

    public ElementsCollection findAll(By seleniumSelector) {
        return new ElementsCollection(this.driver(), seleniumSelector);
    }

    public ElementsCollection findAll(String cssSelector) {
        return new ElementsCollection(this.driver(), By.cssSelector((String)cssSelector));
    }

    public ElementsCollection $$(By criteria) {
        return this.findAll(criteria);
    }

    public @Nullable SelenideElement getSelectedRadio(By radioField) {
        for (WebElement radio : this.$$(radioField).asFixedIterable()) {
            if (radio.getAttribute("checked") == null) continue;
            return this.$(radio);
        }
        return null;
    }

    public Modal modal() {
        return new Modal(this.driver());
    }

    public WebDriverLogs getWebDriverLogs() {
        return new WebDriverLogs(this.driver());
    }

    public void clearBrowserLocalStorage() {
        this.executeJavaScript("localStorage.clear();", new Object[0]);
    }

    public boolean atBottom() {
        return Boolean.TRUE.equals(this.executeJavaScript("return window.scrollY + window.innerHeight >= document.body.scrollHeight", new Object[0]));
    }

    public SelenideTargetLocator switchTo() {
        return this.driver().switchTo();
    }

    public String url() {
        return Objects.requireNonNull(this.getWebDriver().getCurrentUrl());
    }

    public @Nullable String source() {
        return this.getWebDriver().getPageSource();
    }

    public String getCurrentFrameUrl() {
        return Objects.requireNonNull((String)this.executeJavaScript("return window.location.href", new Object[0]));
    }

    public String getUserAgent() {
        return this.driver().getUserAgent();
    }

    public SessionId getSessionId() {
        return this.driver().getSessionId();
    }

    public @Nullable String screenshot(String fileName) {
        return screenshots.takeScreenshot(this.driver(), fileName, true, this.driver().config().savePageSource()).getImage();
    }

    public <T> @Nullable T screenshot(OutputType<T> outputType) {
        return screenshots.takeScreenShot(this.driver(), outputType);
    }

    public File download(String url) throws URISyntaxException {
        return this.download(new URI(url), this.config.timeout());
    }

    public File download(String url, long timeoutMs) throws URISyntaxException {
        return this.download(new URI(url), timeoutMs);
    }

    public File download(URI url) {
        return this.download(url, this.config.timeout());
    }

    public File download(URI url, long timeoutMs) {
        return SelenideDriver.downloadFileWithHttpRequest().download(this.driver(), url, timeoutMs, FileFilters.none());
    }

    public LocalStorage getLocalStorage() {
        return new LocalStorage(this.driver());
    }

    public SessionStorage getSessionStorage() {
        return new SessionStorage(this.driver());
    }

    public Clipboard getClipboard() {
        return Plugins.inject(ClipboardService.class).getClipboard(this.driver());
    }

    private static synchronized DownloadFileWithHttpRequest downloadFileWithHttpRequest() {
        return downloadFileWithHttpRequest.get();
    }

    public Conditional<WebDriver> webdriver() {
        return new WebDriverConditional(this.driver);
    }
}

