/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide;

import com.codeborne.selenide.ScrollDirection;

public record ScrollOptions(ScrollDirection direction, int distance) {
    private static final ScrollDirection DEFAULT_SCROLL_DIRECTION = ScrollDirection.DOWN;
    private static final int DEFAULT_SCROLL_DISTANCE_IN_PIXELS = 1000;

    public static ScrollOptions defaultScrollOptions() {
        return new ScrollOptions(DEFAULT_SCROLL_DIRECTION, 1000);
    }

    public static ScrollOptions direction(ScrollDirection scrollDirection) {
        return new ScrollOptions(scrollDirection, 1000);
    }

    public ScrollOptions distance(int distance) {
        if (distance >= 0) {
            return new ScrollOptions(this.direction, distance);
        }
        throw new IllegalArgumentException("The distance should be a positive number");
    }
}

