/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide;

import com.codeborne.selenide.impl.HasTimeout;
import java.time.Duration;
import org.jspecify.annotations.Nullable;

public record ModalOptions(@Nullable String expectedText, @Nullable Duration timeout) implements HasTimeout
{
    public static ModalOptions none() {
        return new ModalOptions(null, null);
    }

    public static ModalOptions withExpectedText(@Nullable String expectedText) {
        return new ModalOptions(expectedText, null);
    }

    public static ModalOptions withTimeout(Duration timeout) {
        return new ModalOptions(null, timeout);
    }

    public ModalOptions timeout(Duration timeout) {
        return new ModalOptions(this.expectedText, timeout);
    }

    @Override
    public String toString() {
        if (this.expectedText == null && this.timeout == null) {
            return "";
        }
        if (this.expectedText == null) {
            return String.format("timeout: %s", this.timeout);
        }
        if (this.timeout == null) {
            return String.format("expected text: \"%s\"", this.expectedText);
        }
        return String.format("expected text: \"%s\", timeout: %s ms", this.expectedText, this.timeout.toMillis());
    }
}

