/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide;

import com.codeborne.selenide.Driver;
import com.codeborne.selenide.ModalOptions;
import com.codeborne.selenide.ex.DialogTextMismatch;
import com.codeborne.selenide.ex.UIAssertionError;
import com.codeborne.selenide.logevents.SelenideLogger;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.apache.commons.lang3.StringUtils;
import org.jspecify.annotations.Nullable;
import org.openqa.selenium.Alert;

public class Modal {
    private final Driver driver;

    public Modal(Driver driver) {
        this.driver = driver;
    }

    @CanIgnoreReturnValue
    public String confirm() {
        return this.confirm(ModalOptions.none());
    }

    @CanIgnoreReturnValue
    public String confirm(ModalOptions options) {
        return SelenideLogger.get(this.getLogSubject(options), SelenideLogger.getReadableSubject("confirm", new Object[0]), () -> {
            Alert alert = this.driver.switchTo().alert(options.timeout());
            String actualDialogText = alert.getText();
            alert.accept();
            Modal.checkDialogText(this.driver, options.expectedText(), actualDialogText);
            return actualDialogText;
        });
    }

    @CanIgnoreReturnValue
    public String prompt() {
        return this.prompt(ModalOptions.none(), null);
    }

    @CanIgnoreReturnValue
    public String prompt(@Nullable String inputText) {
        return this.prompt(ModalOptions.none(), inputText);
    }

    @CanIgnoreReturnValue
    public String prompt(@Nullable String expectedDialogText, @Nullable String inputText) {
        return this.prompt(ModalOptions.withExpectedText(expectedDialogText), inputText);
    }

    @CanIgnoreReturnValue
    public String prompt(ModalOptions options, @Nullable String inputText) {
        String subject = SelenideLogger.getReadableSubject("prompt", StringUtils.defaultString((String)inputText));
        return SelenideLogger.get(this.getLogSubject(options), subject, () -> {
            Alert alert = this.driver.switchTo().alert(options.timeout());
            String actualDialogText = alert.getText();
            if (inputText != null) {
                alert.sendKeys(inputText);
            }
            alert.accept();
            Modal.checkDialogText(this.driver, options.expectedText(), actualDialogText);
            return actualDialogText;
        });
    }

    @CanIgnoreReturnValue
    public String dismiss() {
        return this.dismiss(ModalOptions.none());
    }

    @CanIgnoreReturnValue
    public String dismiss(@Nullable String expectedDialogText) {
        return this.dismiss(ModalOptions.withExpectedText(expectedDialogText));
    }

    @CanIgnoreReturnValue
    public String dismiss(ModalOptions options) {
        return SelenideLogger.get(this.getLogSubject(options), SelenideLogger.getReadableSubject("dismiss", new Object[0]), () -> {
            Alert alert = this.driver.switchTo().alert(options.timeout());
            String actualDialogText = alert.getText();
            alert.dismiss();
            Modal.checkDialogText(this.driver, options.expectedText(), actualDialogText);
            return actualDialogText;
        });
    }

    private String getLogSubject(ModalOptions options) {
        return String.format("modal(%s)", options);
    }

    private static void checkDialogText(Driver driver, @Nullable String expectedDialogText, String actualDialogText) {
        if (expectedDialogText != null && !expectedDialogText.equals(actualDialogText)) {
            DialogTextMismatch assertionError = new DialogTextMismatch(expectedDialogText, actualDialogText);
            throw UIAssertionError.wrap(driver, (Error)((Object)assertionError), driver.config().timeout());
        }
    }
}

