/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide;

import com.codeborne.selenide.Driver;
import com.codeborne.selenide.ObjectCondition;
import com.codeborne.selenide.impl.Waiter;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.time.Duration;

public interface Conditional<T> {
    public Driver driver();

    public T object();

    @CanIgnoreReturnValue
    default public Conditional<T> shouldHave(ObjectCondition<T> predicate) {
        new Waiter().wait(this.driver(), this.object(), predicate);
        return this;
    }

    @CanIgnoreReturnValue
    default public Conditional<T> shouldHave(ObjectCondition<T> predicate, Duration timeout) {
        new Waiter().wait(this.driver(), this.object(), predicate, timeout);
        return this;
    }

    @CanIgnoreReturnValue
    default public Conditional<T> shouldNotHave(ObjectCondition<T> predicate) {
        new Waiter().waitWhile(this.driver(), this.object(), predicate);
        return this;
    }

    @CanIgnoreReturnValue
    default public Conditional<T> shouldNotHave(ObjectCondition<T> predicate, Duration timeout) {
        new Waiter().waitWhile(this.driver(), this.object(), predicate, timeout);
        return this;
    }
}

