/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.documentintelligence.models;

import com.azure.ai.documentintelligence.models.DocumentFontStyle;
import com.azure.ai.documentintelligence.models.DocumentFontWeight;
import com.azure.ai.documentintelligence.models.DocumentSpan;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class DocumentStyle
implements JsonSerializable<DocumentStyle> {
    private Boolean isHandwritten;
    private String similarFontFamily;
    private DocumentFontStyle fontStyle;
    private DocumentFontWeight fontWeight;
    private String color;
    private String backgroundColor;
    private final List<DocumentSpan> spans;
    private final double confidence;

    private DocumentStyle(List<DocumentSpan> spans, double confidence) {
        this.spans = spans;
        this.confidence = confidence;
    }

    public Boolean isHandwritten() {
        return this.isHandwritten;
    }

    public String getSimilarFontFamily() {
        return this.similarFontFamily;
    }

    public DocumentFontStyle getFontStyle() {
        return this.fontStyle;
    }

    public DocumentFontWeight getFontWeight() {
        return this.fontWeight;
    }

    public String getColor() {
        return this.color;
    }

    public String getBackgroundColor() {
        return this.backgroundColor;
    }

    public List<DocumentSpan> getSpans() {
        return this.spans;
    }

    public double getConfidence() {
        return this.confidence;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("spans", this.spans, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeDoubleField("confidence", this.confidence);
        jsonWriter.writeBooleanField("isHandwritten", this.isHandwritten);
        jsonWriter.writeStringField("similarFontFamily", this.similarFontFamily);
        jsonWriter.writeStringField("fontStyle", this.fontStyle == null ? null : this.fontStyle.toString());
        jsonWriter.writeStringField("fontWeight", this.fontWeight == null ? null : this.fontWeight.toString());
        jsonWriter.writeStringField("color", this.color);
        jsonWriter.writeStringField("backgroundColor", this.backgroundColor);
        return jsonWriter.writeEndObject();
    }

    public static DocumentStyle fromJson(JsonReader jsonReader) throws IOException {
        return (DocumentStyle)jsonReader.readObject(reader -> {
            List spans = null;
            double confidence = 0.0;
            Boolean isHandwritten = null;
            String similarFontFamily = null;
            DocumentFontStyle fontStyle = null;
            DocumentFontWeight fontWeight = null;
            String color = null;
            String backgroundColor = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("spans".equals(fieldName)) {
                    spans = reader.readArray(reader1 -> DocumentSpan.fromJson(reader1));
                    continue;
                }
                if ("confidence".equals(fieldName)) {
                    confidence = reader.getDouble();
                    continue;
                }
                if ("isHandwritten".equals(fieldName)) {
                    isHandwritten = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("similarFontFamily".equals(fieldName)) {
                    similarFontFamily = reader.getString();
                    continue;
                }
                if ("fontStyle".equals(fieldName)) {
                    fontStyle = DocumentFontStyle.fromString(reader.getString());
                    continue;
                }
                if ("fontWeight".equals(fieldName)) {
                    fontWeight = DocumentFontWeight.fromString(reader.getString());
                    continue;
                }
                if ("color".equals(fieldName)) {
                    color = reader.getString();
                    continue;
                }
                if ("backgroundColor".equals(fieldName)) {
                    backgroundColor = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            DocumentStyle deserializedDocumentStyle = new DocumentStyle(spans, confidence);
            deserializedDocumentStyle.isHandwritten = isHandwritten;
            deserializedDocumentStyle.similarFontFamily = similarFontFamily;
            deserializedDocumentStyle.fontStyle = fontStyle;
            deserializedDocumentStyle.fontWeight = fontWeight;
            deserializedDocumentStyle.color = color;
            deserializedDocumentStyle.backgroundColor = backgroundColor;
            return deserializedDocumentStyle;
        });
    }
}

