/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.documentintelligence.models;

import com.azure.ai.documentintelligence.models.AzureBlobContentSource;
import com.azure.ai.documentintelligence.models.AzureBlobFileListContentSource;
import com.azure.ai.documentintelligence.models.ContentSourceKind;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class ClassifierDocumentTypeDetails
implements JsonSerializable<ClassifierDocumentTypeDetails> {
    private ContentSourceKind sourceKind;
    private AzureBlobContentSource azureBlobSource;
    private AzureBlobFileListContentSource azureBlobFileListSource;

    public ContentSourceKind getSourceKind() {
        return this.sourceKind;
    }

    public ClassifierDocumentTypeDetails setSourceKind(ContentSourceKind sourceKind) {
        this.sourceKind = sourceKind;
        return this;
    }

    public AzureBlobContentSource getAzureBlobSource() {
        return this.azureBlobSource;
    }

    public ClassifierDocumentTypeDetails setAzureBlobSource(AzureBlobContentSource azureBlobSource) {
        this.azureBlobSource = azureBlobSource;
        return this;
    }

    public AzureBlobFileListContentSource getAzureBlobFileListSource() {
        return this.azureBlobFileListSource;
    }

    public ClassifierDocumentTypeDetails setAzureBlobFileListSource(AzureBlobFileListContentSource azureBlobFileListSource) {
        this.azureBlobFileListSource = azureBlobFileListSource;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("sourceKind", this.sourceKind == null ? null : this.sourceKind.toString());
        jsonWriter.writeJsonField("azureBlobSource", (JsonSerializable)this.azureBlobSource);
        jsonWriter.writeJsonField("azureBlobFileListSource", (JsonSerializable)this.azureBlobFileListSource);
        return jsonWriter.writeEndObject();
    }

    public static ClassifierDocumentTypeDetails fromJson(JsonReader jsonReader) throws IOException {
        return (ClassifierDocumentTypeDetails)jsonReader.readObject(reader -> {
            ClassifierDocumentTypeDetails deserializedClassifierDocumentTypeDetails = new ClassifierDocumentTypeDetails();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sourceKind".equals(fieldName)) {
                    deserializedClassifierDocumentTypeDetails.sourceKind = ContentSourceKind.fromString(reader.getString());
                    continue;
                }
                if ("azureBlobSource".equals(fieldName)) {
                    deserializedClassifierDocumentTypeDetails.azureBlobSource = AzureBlobContentSource.fromJson(reader);
                    continue;
                }
                if ("azureBlobFileListSource".equals(fieldName)) {
                    deserializedClassifierDocumentTypeDetails.azureBlobFileListSource = AzureBlobFileListContentSource.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedClassifierDocumentTypeDetails;
        });
    }
}

