/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.documentintelligence.models;

import com.azure.ai.documentintelligence.models.AzureBlobContentSource;
import com.azure.ai.documentintelligence.models.AzureBlobFileListContentSource;
import com.azure.ai.documentintelligence.models.DocumentBuildMode;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Map;

public final class BuildDocumentModelOptions
implements JsonSerializable<BuildDocumentModelOptions> {
    private final String modelId;
    private String description;
    private final DocumentBuildMode buildMode;
    private AzureBlobContentSource azureBlobSource;
    private AzureBlobFileListContentSource azureBlobFileListSource;
    private Map<String, String> tags;
    private Double maxTrainingHours;
    private Boolean allowOverwrite;

    public BuildDocumentModelOptions(String modelId, DocumentBuildMode buildMode) {
        this.modelId = modelId;
        this.buildMode = buildMode;
    }

    public String getModelId() {
        return this.modelId;
    }

    public String getDescription() {
        return this.description;
    }

    public BuildDocumentModelOptions setDescription(String description) {
        this.description = description;
        return this;
    }

    public DocumentBuildMode getBuildMode() {
        return this.buildMode;
    }

    public AzureBlobContentSource getAzureBlobSource() {
        return this.azureBlobSource;
    }

    public BuildDocumentModelOptions setAzureBlobSource(AzureBlobContentSource azureBlobSource) {
        this.azureBlobSource = azureBlobSource;
        return this;
    }

    public AzureBlobFileListContentSource getAzureBlobFileListSource() {
        return this.azureBlobFileListSource;
    }

    public BuildDocumentModelOptions setAzureBlobFileListSource(AzureBlobFileListContentSource azureBlobFileListSource) {
        this.azureBlobFileListSource = azureBlobFileListSource;
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public BuildDocumentModelOptions setTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public Double getMaxTrainingHours() {
        return this.maxTrainingHours;
    }

    public BuildDocumentModelOptions setMaxTrainingHours(Double maxTrainingHours) {
        this.maxTrainingHours = maxTrainingHours;
        return this;
    }

    public Boolean isAllowOverwrite() {
        return this.allowOverwrite;
    }

    public BuildDocumentModelOptions setAllowOverwrite(Boolean allowOverwrite) {
        this.allowOverwrite = allowOverwrite;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("modelId", this.modelId);
        jsonWriter.writeStringField("buildMode", this.buildMode == null ? null : this.buildMode.toString());
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeJsonField("azureBlobSource", (JsonSerializable)this.azureBlobSource);
        jsonWriter.writeJsonField("azureBlobFileListSource", (JsonSerializable)this.azureBlobFileListSource);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        jsonWriter.writeNumberField("maxTrainingHours", (Number)this.maxTrainingHours);
        jsonWriter.writeBooleanField("allowOverwrite", this.allowOverwrite);
        return jsonWriter.writeEndObject();
    }

    public static BuildDocumentModelOptions fromJson(JsonReader jsonReader) throws IOException {
        return (BuildDocumentModelOptions)jsonReader.readObject(reader -> {
            String modelId = null;
            DocumentBuildMode buildMode = null;
            String description = null;
            AzureBlobContentSource azureBlobSource = null;
            AzureBlobFileListContentSource azureBlobFileListSource = null;
            Map tags = null;
            Double maxTrainingHours = null;
            Boolean allowOverwrite = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("modelId".equals(fieldName)) {
                    modelId = reader.getString();
                    continue;
                }
                if ("buildMode".equals(fieldName)) {
                    buildMode = DocumentBuildMode.fromString(reader.getString());
                    continue;
                }
                if ("description".equals(fieldName)) {
                    description = reader.getString();
                    continue;
                }
                if ("azureBlobSource".equals(fieldName)) {
                    azureBlobSource = AzureBlobContentSource.fromJson(reader);
                    continue;
                }
                if ("azureBlobFileListSource".equals(fieldName)) {
                    azureBlobFileListSource = AzureBlobFileListContentSource.fromJson(reader);
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    tags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("maxTrainingHours".equals(fieldName)) {
                    maxTrainingHours = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("allowOverwrite".equals(fieldName)) {
                    allowOverwrite = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            BuildDocumentModelOptions deserializedBuildDocumentModelOptions = new BuildDocumentModelOptions(modelId, buildMode);
            deserializedBuildDocumentModelOptions.description = description;
            deserializedBuildDocumentModelOptions.azureBlobSource = azureBlobSource;
            deserializedBuildDocumentModelOptions.azureBlobFileListSource = azureBlobFileListSource;
            deserializedBuildDocumentModelOptions.tags = tags;
            deserializedBuildDocumentModelOptions.maxTrainingHours = maxTrainingHours;
            deserializedBuildDocumentModelOptions.allowOverwrite = allowOverwrite;
            return deserializedBuildDocumentModelOptions;
        });
    }
}

