/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.documentintelligence.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Map;

public final class AuthorizeClassifierCopyOptions
implements JsonSerializable<AuthorizeClassifierCopyOptions> {
    private final String classifierId;
    private String description;
    private Map<String, String> tags;

    public AuthorizeClassifierCopyOptions(String classifierId) {
        this.classifierId = classifierId;
    }

    public String getClassifierId() {
        return this.classifierId;
    }

    public String getDescription() {
        return this.description;
    }

    public AuthorizeClassifierCopyOptions setDescription(String description) {
        this.description = description;
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public AuthorizeClassifierCopyOptions setTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("classifierId", this.classifierId);
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static AuthorizeClassifierCopyOptions fromJson(JsonReader jsonReader) throws IOException {
        return (AuthorizeClassifierCopyOptions)jsonReader.readObject(reader -> {
            String classifierId = null;
            String description = null;
            Map tags = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("classifierId".equals(fieldName)) {
                    classifierId = reader.getString();
                    continue;
                }
                if ("description".equals(fieldName)) {
                    description = reader.getString();
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    tags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            AuthorizeClassifierCopyOptions deserializedAuthorizeClassifierCopyOptions = new AuthorizeClassifierCopyOptions(classifierId);
            deserializedAuthorizeClassifierCopyOptions.description = description;
            deserializedAuthorizeClassifierCopyOptions.tags = tags;
            return deserializedAuthorizeClassifierCopyOptions;
        });
    }
}

