/*
 * Decompiled with CFR 0.152.
 */
package com.akathist.maven.plugins.launch4j.tools;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;

public final class ResourceIO {
    private static final int DEFAULT_BUFFER_SIZE = 4096;

    private ResourceIO() {
    }

    private static byte[] readAllBytes(InputStream is) throws IOException {
        int bytesRead;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buf = new byte[4096];
        while ((bytesRead = is.read(buf)) != -1) {
            baos.write(buf, 0, bytesRead);
        }
        return baos.toByteArray();
    }

    public static byte[] readResourceAsBytes(String resName) throws IOException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try (InputStream is = cl.getResourceAsStream(resName);){
            if (is == null) {
                throw new IOException("Resource not found: " + resName);
            }
            byte[] byArray = ResourceIO.readAllBytes(is);
            return byArray;
        }
    }

    public static void writeBytesIfDiff(File outFile, byte[] outBytes) throws IOException {
        byte[] existingBytes;
        if (outFile.exists() && Arrays.equals(outBytes, existingBytes = ResourceIO.readBytes(outFile))) {
            return;
        }
        ResourceIO.writeBytes(outFile, outBytes);
    }

    public static byte[] readBytes(File inFile) throws IOException {
        try (FileInputStream fis = new FileInputStream(inFile);){
            byte[] byArray;
            try (BufferedInputStream bis = new BufferedInputStream(fis);){
                byArray = ResourceIO.readAllBytes(bis);
            }
            return byArray;
        }
    }

    public static void writeBytes(File outFile, byte[] outBytes) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(outFile, false);
             BufferedOutputStream bos = new BufferedOutputStream(fos);){
            bos.write(outBytes);
            bos.flush();
        }
    }
}

