/*
 * Decompiled with CFR 0.152.
 */
package com.akathist.maven.plugins.launch4j;

import com.akathist.maven.plugins.launch4j.generators.CopyrightGenerator;
import com.akathist.maven.plugins.launch4j.generators.Launch4jFileVersionGenerator;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import net.sf.launch4j.config.LanguageID;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.model.Organization;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

public class VersionInfo {
    private static final Map<String, LanguageID> LANGUAGE_TO_LANGUAGE_ID = new HashMap<String, LanguageID>();
    @Parameter
    String fileVersion;
    @Parameter
    String txtFileVersion;
    @Parameter
    String fileDescription;
    @Parameter
    String copyright;
    @Parameter
    String productVersion;
    @Parameter
    String txtProductVersion;
    @Parameter
    String productName;
    @Parameter
    String companyName;
    @Parameter
    String internalName;
    @Parameter
    String originalFilename;
    @Parameter
    String language = LanguageID.ENGLISH_US.name();
    @Parameter
    String trademarks;
    private Log log;

    public VersionInfo() {
    }

    public VersionInfo(String fileVersion, String txtFileVersion, String fileDescription, String copyright, String productVersion, String txtProductVersion, String productName, String companyName, String internalName, String originalFilename, String language, String trademarks, Log log) {
        this.fileVersion = fileVersion;
        this.txtFileVersion = txtFileVersion;
        this.fileDescription = fileDescription;
        this.copyright = copyright;
        this.productVersion = productVersion;
        this.txtProductVersion = txtProductVersion;
        this.productName = productName;
        this.companyName = companyName;
        this.internalName = internalName;
        this.originalFilename = originalFilename;
        this.language = language;
        this.trademarks = trademarks;
        this.log = log;
    }

    public void setLog(Log log) {
        this.log = log;
    }

    net.sf.launch4j.config.VersionInfo toL4j() {
        net.sf.launch4j.config.VersionInfo ret = new net.sf.launch4j.config.VersionInfo();
        ret.setFileVersion(this.fileVersion);
        ret.setTxtFileVersion(this.txtFileVersion);
        ret.setFileDescription(this.fileDescription);
        ret.setCopyright(this.copyright);
        ret.setProductVersion(this.productVersion);
        ret.setTxtProductVersion(this.txtProductVersion);
        ret.setProductName(this.productName);
        ret.setCompanyName(this.companyName);
        ret.setInternalName(this.internalName);
        ret.setOriginalFilename(this.originalFilename);
        this.setLanguage(ret);
        ret.setTrademarks(this.trademarks);
        return ret;
    }

    private void setLanguage(net.sf.launch4j.config.VersionInfo ret) {
        LanguageID languageID = LANGUAGE_TO_LANGUAGE_ID.get(this.language);
        if (languageID == null) {
            languageID = LanguageID.ENGLISH_US;
        }
        ret.setLanguage(languageID);
    }

    void tryFillOutByDefaults(MavenProject project, File outfile) {
        if (project == null) {
            throw new IllegalArgumentException("'project' is required, but it is null.");
        }
        if (outfile == null) {
            throw new IllegalArgumentException("'outfile' is required, but it is null.");
        }
        String version = this.getDefaultWhenSourceIsBlankAndLogWarn(project.getVersion(), "1.0.0", "project.version");
        Organization organization = project.getOrganization();
        String organizationName = "Default organization";
        if (organization == null) {
            this.logWarningAboutDummyValue("project.organization.name", organizationName);
        } else {
            organizationName = this.getDefaultWhenSourceIsBlankAndLogWarn(organization.getName(), organizationName, "project.organization.name");
        }
        this.tryFillOutByDefaultVersionInL4jFormat(version);
        this.tryFillOutCopyrightByDefaults(this.getDefaultWhenSourceIsBlankAndLogWarn(project.getInceptionYear(), "2020", "project.inceptionYear"), organizationName);
        this.tryFillOutOrganizationRelatedDefaults(organizationName);
        this.tryFillOutSimpleValuesByDefaults(version, this.getDefaultWhenSourceIsBlankAndLogWarn(project.getName(), "Java Project", "project.name"), this.getDefaultWhenSourceIsBlankAndLogWarn(project.getArtifactId(), "java-project", "project.artifactId"), this.getDefaultWhenSourceIsBlankAndLogWarn(project.getDescription(), "A Java project.", "project.description"));
        String outfileName = this.getDefaultWhenSourceIsBlankAndLogWarn(outfile.getName(), "app.exe", "outfile");
        this.originalFilename = this.getDefaultWhenSourceIsBlank(this.originalFilename, outfileName);
    }

    private void tryFillOutByDefaultVersionInL4jFormat(String version) {
        String defaultFileVersion = Launch4jFileVersionGenerator.generate(version);
        this.fileVersion = this.getDefaultWhenSourceIsBlank(this.fileVersion, defaultFileVersion);
        this.productVersion = this.getDefaultWhenSourceIsBlank(this.productVersion, defaultFileVersion);
    }

    private void tryFillOutCopyrightByDefaults(String inceptionYear, String organizationName) {
        String defaultCopyright = CopyrightGenerator.generate(inceptionYear, organizationName);
        this.copyright = this.getDefaultWhenSourceIsBlank(this.copyright, defaultCopyright);
    }

    private void tryFillOutOrganizationRelatedDefaults(String organizationName) {
        this.companyName = this.getDefaultWhenSourceIsBlank(this.companyName, organizationName);
        this.trademarks = this.getDefaultWhenSourceIsBlank(this.trademarks, organizationName);
    }

    private void tryFillOutSimpleValuesByDefaults(String version, String name, String artifactId, String description) {
        this.txtFileVersion = this.getDefaultWhenSourceIsBlank(this.txtFileVersion, version);
        this.txtProductVersion = this.getDefaultWhenSourceIsBlank(this.txtProductVersion, version);
        this.productName = this.getDefaultWhenSourceIsBlank(this.productName, name);
        this.internalName = this.getDefaultWhenSourceIsBlank(this.internalName, artifactId);
        this.fileDescription = this.getDefaultWhenSourceIsBlank(this.fileDescription, description);
    }

    private String getDefaultWhenSourceIsBlank(String source, String defaultValue) {
        if (StringUtils.isBlank((CharSequence)source)) {
            return defaultValue;
        }
        return source;
    }

    private String getDefaultWhenSourceIsBlankAndLogWarn(String source, String defaultValue, String sourceParamName) {
        if (StringUtils.isBlank((CharSequence)source)) {
            this.logWarningAboutDummyValue(sourceParamName, defaultValue);
            return defaultValue;
        }
        return source;
    }

    private void logWarningAboutDummyValue(String sourceParamName, String dummyValue) {
        this.log.warn((CharSequence)("Configuration param ${" + sourceParamName + "} is empty, so a dummy value \"" + dummyValue + "\" might be used instead to fulfill some of VersionInfo params by defaults."));
    }

    public String toString() {
        return "VersionInfo{fileVersion='" + this.fileVersion + "', txtFileVersion='" + this.txtFileVersion + "', fileDescription='" + this.fileDescription + "', copyright='" + this.copyright + "', productVersion='" + this.productVersion + "', txtProductVersion='" + this.txtProductVersion + "', productName='" + this.productName + "', companyName='" + this.companyName + "', internalName='" + this.internalName + "', originalFilename='" + this.originalFilename + "', language='" + this.language + "', trademarks='" + this.trademarks + "'}";
    }

    static {
        for (LanguageID languageID : LanguageID.values()) {
            LANGUAGE_TO_LANGUAGE_ID.put(languageID.name(), languageID);
        }
    }
}

